/* LgraphP.h - Private Lgraph Widget Defs
 *------------------------------------------------------------*
 * Copyright 1988, Fil Alleva and Carnegie Mellon University
 *------------------------------------------------------------*
 * HISTORY
 */

#ifndef _XtLgraphP_h
#define _XtLgraphP_h

#include <Lgraph.h>
#include <LyreDispP.h>

#include <sys/types.h>
#include <vdata.h>

/*
 * New fields for the Lgraph widget instance record
 */
typedef struct {
    Pixel               foreground_pixel;  /* Foreground Pixel */
    GC                  myGC;		   /* Pointer to Graphics Context */
    GC                  bracketGC;         /* GC for brackets */
    Boolean             reverse_video;	   /* Reverse Video Flag */
    int                 nsegments;	   /* Number of segments */
    XSegment           *segments;	   /* The segments that describe the
					    * graph */
    vdata_t            *input_data;	   /* New data is placed here */
    vdata_t            *data;		   /* Data object */
    Boolean		negate_data;	   /* Turn data upside down */

    ScaleWidget	        hscale_widget;	  /* Hscale widget (if there is one) */
    ScaleWidget	        vscale_widget;	  /* Vscale widget (if there is one) */

    float		data_min;	   /* min data value */
    float		data_max;	   /* max data value */

    Boolean		brackets_on;	   /* Are the bracket displayed ? */
    int			left_bracket_x;	   /* Left bracket x coordinate */
    int			right_bracket_x;   /* Left bracket x coordinate */
}                   LgraphPart;

/*
 * Full instance record declaration
 */
typedef struct _LgraphRec {
    CorePart core;
    LyreDispPart lyreDisp;
    LgraphPart lgraph;
}   LgraphRec;

/*
 * New fields for the Lgraph widget class record
 */
typedef struct {int dummy;} LgraphClassPart;

/*
 * Full class record declaration.
 */
typedef struct _LgraphClassRec {
    CoreClassPart core_class;
    LyreDispClassPart lyreDisp_class;
    LgraphClassPart lgraph_class;
}   LgraphClassRec;

/*
 * Class pointer.
 */
extern LgraphClassRec lgraphClassRec;

#endif _XtLgraphP_h
