/* LScrollP.h - Private definitions for LScroll widget
 *------------------------------------------------------------*
 * HISTORY
 * 19-Jan-89  Fil Alleva (faa) at Carnegie-Mellon University
 *	Deleted vwidgets and vcount field since viewported widgets
 *	are obsolete.
 *
 * 
 */

#ifndef _XtLScrollP_h
#define _XtLScrollP_h

#include <LScroll.h>
#include <X11/CoreP.h>
#include <X11/Xaw/ScrollbarP.h>

typedef struct {
    GC                  copyGC;		   /* GC to use for copy */
    float               thumb_pos;	   /* thumb position */
    WidgetList	        swidgets;	   /* Scrolled widgets */
    int                 count;		   /* Count of lscrolled widgets */
    Widget              max_widget;	   /* Max Virtual width widget */
}                   LScrollPart;

typedef struct _LScrollRec {
    CorePart            core;

#ifndef X11R4                            /* the decs still use X11r4 so they */
    SimplePart          simple;             /* don't support this SimplePart */
#endif

    ScrollbarPart	scrollbar;
    LScrollPart         lscroll;
}                   LScrollRec;

typedef struct _LScrollClass 
{
    int makes_compiler_happy;	/* not used */
} LScrollClassPart;

typedef struct _LScrollClassRec {
    CoreClassPart	core_class;

#ifndef X11R4                            /* the decs still use X11r4 so they */
    SimpleClassPart     simple_class; /* don't support this SimpleClassPart. */
#endif

    ScrollbarClassPart	scrollbar_class;
    LScrollClassPart	lscroll_class;
}   LScrollClassRec;

extern LScrollClassRec lscrollClassRec;

#endif _XtLScrollP_h
