static char *rcsident = "$Header: /projects/cslu/speech/work/src/bin/auto_lyre/RCS/LScroll.c,v 4.4 1993/05/28 21:27:40 johans Exp $";

/*
 * LScroll.c - LScroll widget
 *------------------------------------------------------------*
 * HISTORY
 * 19-Jan-89  Fil Alleva (faa) at Carnegie-Mellon University
 *	Deleted code that used to handle viewported widgets.
 *
 * 13-Apr-93 Johan Schalkwyk at Oregon graduate Institute
 *      changed to ANSI style header declarations
 *
 */

/* Standard C library include file directives */
#include <stdio.h>
#include <c.h>
#include <ctype.h>

/* X library include file directives */
#include <X11/Xos.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include <X11/Xmu/Misc.h>
#include <X11/Xaw/Scrollbar.h>

/* Lyre Include file directives */
#include <LyreDispP.h>
#include <LScrollP.h>
#include <Scale.h>

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

/* Private Data */
static int Zero = 0;

/* Procedure header declarations */
static void Initialize (Widget request_in, Widget new_in, ArgList arglist,
			Cardinal *num_args);
static void scroll_thumb (LScrollWidget sw, caddr_t cdata,
			  caddr_t percent_ptr);
static void scroll_point (LScrollWidget sw, caddr_t cdata, int pos);
static void compute_max_virtual_width_widget (LScrollWidget sw);

void LScrollDeleteWidget (Widget w, LScrollWidget sw);
void LScrollSetWidgetVirtualWidth (Widget w, LScrollWidget sw, int vwidth);
void LScroll (Widget sw, float percent_change);
void LScrollSet (Widget sw, float percent);

#define offset(field) XtOffset(LScrollWidget, field)
static XtResource resources[] = { 
   {XtNorientation, XtCOrientation, XtROrientation, sizeof(XtOrientation),
      offset(scrollbar.orientation), XtRString, "horizontal"},

   {XtNwidgets, XtCParameter, XtRPointer, sizeof(int), 
      offset(lscroll.swidgets), XtRPointer, (caddr_t)NULL},
   {XtNcount, XtCCount, XtRInt, sizeof(int), 
      offset(lscroll.count), XtRInt, (caddr_t)&Zero},
};
#undef offset


LScrollClassRec lscrollClassRec = {
  {
    (WidgetClass) &scrollbarClassRec,	/* superclass		  */	
    "LScroll",				/* class_name		  */
    sizeof(LScrollRec),			/* size			  */
    NULL,				/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    0,					/* actions		  */
    NULL,				/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    TRUE,				/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    XtInheritResize,			/* resize		  */
    XtInheritExpose,			/* expose		  */
    NULL,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    XtInheritTranslations,		/* tm_table		  */
    NULL,				/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL,				/* extension		  */
  },  /* CoreClass fields initialization */

#ifndef X11R4
  { /* simple fields */
    /* change_sensitive         */      XtInheritChangeSensitive
  },
#endif

};

WidgetClass lscrollWidgetClass = (WidgetClass) &lscrollClassRec;


/*
 * Initialize (request, new)
 *
 */

static void Initialize (Widget request_in, Widget new_in, ArgList arglist,
			Cardinal *num_args)
{
    LScrollWidget request = (LScrollWidget) request_in;
    LScrollWidget new     = (LScrollWidget) new_in;

    XtGCMask valuemask;
    XGCValues myXGCV;

    valuemask = GCGraphicsExposures | GCClipXOrigin;

    myXGCV.clip_x_origin = 0;
    myXGCV.graphics_exposures = TRUE;	/* default */
    new->lscroll.copyGC = XtGetGC ((Widget) new, valuemask, &myXGCV);

    new->lscroll.thumb_pos = 0;
    
    compute_max_virtual_width_widget (new);

    XtAddCallback((Widget)new,XtNjumpProc, (XtCallbackProc) scroll_thumb, 0);
    XtAddCallback((Widget)new,XtNscrollProc, (XtCallbackProc) scroll_point, 0);
}


/* 
 * scroll_thumb (sw, cdata, percent_ptr)
 *
 * The goal here is to keep smae time in each window in the
 * middle of the window
 *
 */

static void scroll_thumb (LScrollWidget sw, caddr_t cdata, caddr_t percent_ptr)
{
    int                 length = sw->scrollbar.length;
    register int        i, xchange;
    register LyreDispWidget     w;
    register LyreDispWidget     mw = (LyreDispWidget) sw->lscroll.max_widget;
    register float      thumbwidth;
    float	        percent;
    XEvent              event;
    float		time;
    u_int		window_middle, new_window_middle;

    /*
     * When max_widget is 0 no data is displayed yet.
     */
    if (mw == 0)
	return;

    thumbwidth = (float) ( ((float)length) / 
				((float)(mw->lyreDisp.virtual_width)) );

    if( thumbwidth > 1.0 ) {
	thumbwidth = 1.0;
    }

    percent = *(float *)percent_ptr;

    if (percent < 0.0)
	percent = 0.0;
    else if (percent > 1.0)
	percent = 1.0;

    sw->lscroll.thumb_pos = percent - (thumbwidth / 2.0);
    XawScrollbarSetThumb ((Widget) sw, sw->lscroll.thumb_pos, thumbwidth);

    /*
     * This is the target time for all windows
     */
    time = (mw->lyreDisp.virtual_width * percent) * mw->lyreDisp.secs_ppix;

    for (i = 0; i < sw->lscroll.count; i++) {
	w = (LyreDispWidget) sw->lscroll.swidgets[i];
	new_window_middle = SecsToPix (w, time) + w->lyreDisp.virtual_x;
	window_middle = w->lyreDisp.virtual_x + (w->core.width / 2);
	xchange = window_middle - new_window_middle;

	w->lyreDisp.virtual_x = new_window_middle - (w->core.width / 2);
	if (xchange < 0) {
	    XCopyArea (XtDisplay (w), XtWindow (w), XtWindow (w),
			sw->lscroll.copyGC,    -xchange, 0,
		       w->core.width, w->core.height,
		       0, 0);
	}
	else if (xchange > 0) {
	    XCopyArea (XtDisplay (w), XtWindow (w), XtWindow (w),
			sw->lscroll.copyGC,   0, 0,
		       w->core.width, w->core.height,
		       xchange, 0);
	    XClearArea (XtDisplay (w), XtWindow (w), 0, 0,
			xchange, w->core.height, TRUE);
	}
    }

    XSync (XtDisplay (sw), FALSE);
    while (XCheckMaskEvent (XtDisplay (sw), ExposureMask, &event)) {
	XtDispatchEvent (&event);
    }
}


/*
 * scroll_point (sw, cdata, pos)
 *
 */

static void scroll_point (LScrollWidget sw, caddr_t cdata, int pos)
{
    LyreDispWidget  mw = (LyreDispWidget) sw->lscroll.max_widget;
    register int    length = sw->scrollbar.length;
    register float  percent_change = (float) ((float)pos) / ((float)length);
    register float  thumbwidth;
    float	    percent = sw->lscroll.thumb_pos;
    caddr_t	    percent_ptr;

    /*
     * If max widget is 0 no data is displayed yet.
     */
    if (mw == 0)
	return;

    thumbwidth = (float) ( ((float)length) / 
				((float)mw->lyreDisp.virtual_width) );

    percent += (percent_change * thumbwidth);
    percent += (thumbwidth/2.0);

    percent_ptr = (caddr_t) &percent;

    scroll_thumb (sw, cdata, percent_ptr);
}


/*
 * compute_max_virtual_width_widget (sw)
 *
 */

static void compute_max_virtual_width_widget ( LScrollWidget sw)
{
    register int i;
    register max = 0;
    LyreDispWidget w;

    for (i = 0; i < sw->lscroll.count; i++) {
	w = (LyreDispWidget) sw->lscroll.swidgets[i];
	if (max < w->lyreDisp.virtual_width) {
	    max = w->lyreDisp.virtual_width;
	    sw->lscroll.max_widget = sw->lscroll.swidgets[i];
	}
    }
}


/*
 * LScrollAddwidget (w, sw)
 *
 * Add widget w to the scrolled list
 *
 */

void LScrollAddWidget (Widget w, LScrollWidget sw)
{
    sw->lscroll.swidgets = (WidgetList) XtRealloc (
		(char *) sw->lscroll.swidgets,
		(Cardinal) (sizeof (Widget) * (sw->lscroll.count + 1)));
    sw->lscroll.swidgets[sw->lscroll.count] = w;
    sw->lscroll.count++;
}


/*
 * LScrollDeleteWidget (w, sw)
 *
 * Delete widget w from the scrolled list
 *
 */

void LScrollDeleteWidget (Widget w, LScrollWidget sw)
{
    WidgetList wltmp = (WidgetList) XtMalloc (sizeof(Widget) * 
					      sw->lscroll.count);
    register int i, j;

    for (j = 0, i = 0; i < sw->lscroll.count; i++) {
	if (sw->lscroll.swidgets[i] != w)
	    wltmp[j++] = sw->lscroll.swidgets[i];
    }
    if (j == i) {
	XtAlert ("scroll_delete: Warning widget not found");
	XtFree ((char *) wltmp);
	return;
    }

    XtFree ((char *) sw->lscroll.swidgets);
    sw->lscroll.swidgets = wltmp;
    sw->lscroll.count--;
    compute_max_virtual_width_widget (sw);
}


/*
 * LScrollSetWidgetVirtualWidth (w, sw, vwidth)
 *
 */

void LScrollSetWidgetVirtualWidth (Widget w, LScrollWidget sw, 
				   int vwidth)
{
    float thumbwidth;
    LyreDispWidget lw;

    compute_max_virtual_width_widget (sw);

    lw = (LyreDispWidget) sw->lscroll.max_widget;

    thumbwidth = (float) ( ((float)sw->scrollbar.length) /
			((float)lw->lyreDisp.virtual_width));

    if( thumbwidth > 1.0 ) {
	thumbwidth = 1.0;
    }

    XawScrollbarSetThumb ((Widget) sw, sw->lscroll.thumb_pos, thumbwidth );
}


/*
 * LScroll (sw, percent_change)
 *
 */

void LScroll (Widget sw, float percent_change)
{
    int pos;

    if (sw == NULL)
      return;

    pos = sw->core.width * percent_change;
    scroll_point ((LScrollWidget)sw, 0, pos);
}


/*
 * LScrollSet (sw, percent)
 *
 */

void LScrollSet (Widget sw, float percent)
{
    caddr_t percent_ptr;

    if (sw == NULL)
      return;

    percent_ptr = (caddr_t) &percent;

    scroll_thumb ( (LScrollWidget)sw, 0, percent_ptr);
}
