/*$header$*/
/* Gspec.h - Public Gspec Widget Defs
 *------------------------------------------------------------*
 * HISTORY
 *  1-Mar-89  Fil Alleva (faa) at Carnegie-Mellon University
 *	Added Resource name "lineardata".
 *
 */

#ifndef _XtGspec_h
#define _XtGspec_h

/***********************************************************************
 *
 * Gspec Widget
 *
 ***********************************************************************/


/* Resource names used to the gspec widget
 */
#define XtNresolution	"resolution"	/* (u_int) Resolution */

#define XtNdata		"data"		/* (vdata_t *) Data Object */
#define XtNrange	"range"		/* (int) range of values */
#define XtNcnt		"count"		/* (int) number of bit vectors */
#define XtNsampsPerSec  "sampspersec"   /* (float) samples per second */
#define XtNstart_time   "start_time"    /* (float) start time of image */
#define XtNaoffset      "aoffset"       /* (float) alginment offset of image */
#define XtNhscaleWidget "hscalewidget"	/* The optional hscale widget */
#define XtNvscaleWidget "vscalewidget"	/* The optional vscale widget */

#define XtNpminWidget "pminwidget"	/* The pos min value text widget */
#define XtNpmaxWidget "pmaxwidget"	/* The pos max value text widget */
#define XtNnminWidget "nminwidget"	/* The neg min value text widget */
#define XtNnmaxWidget "nmaxwidget"	/* The neg max value text widget */

#define XtNhorizScaleOn	"horizscaleon"
#define XtNvertScaleOn	"vertscaleon"
#define XtNlinearData	"lineardata"	/* TRUE if the display should NOT
					 * be massaged */
#define XtNrowlabel     "rowlabel"

#define XtNposmin	"posmin"
#define XtNposmax	"posmax"
#define XtNposcolors	"poscolors"
#define XtNnegmin	"negmin"
#define XtNnegmax	"negmax"
#define XtNnegcolors	"negcolors"
#define XtNexp     	"exp"

#define XtNLYRElow_color	"low_color"
#define XtCLYRElow_color	"Low_color"
#define XtNLYREzero_color	"zero_color"
#define XtCLYREzero_color	"Zero_color"
#define XtNLYREhigh_color	"high_color"
#define XtCLYREhigh_color	"High_color"

typedef struct _GspecRec *GspecWidget;	   /* defined in GspecP.h */
typedef struct _GspecClassRec *GspecWidgetClass; /* defined in GspecP.h */

extern WidgetClass gspecWidgetClass;

#endif _XtGspec_h

