/* AdctoolP.h - Private definitions for Adc tool widget
 *------------------------------------------------------------*
 * Copyright 1988, Fil Alleva and Carnegie Mellon University
 *------------------------------------------------------------*
 * HISTORY
 * 23-Jun-89  Fil Alleva (faa) at Carnegie-Mellon University
 *	Deleted mark_managed field.
 *
 */

#ifndef _XtAdctooltP_h
#define _XtAdctooltP_h

#include <vdata.h>
#include <Adctool.h>
#include <X11/Xaw/FormP.h>

typedef struct _AdctoolClass 
{
    int makes_compiler_happy;	/* not used */
} AdctoolClassPart;

typedef struct _AdctoolClassRec {
    CoreClassPart       core_class;
    CompositeClassPart  composite_class;
    ConstraintClassPart constraint_class;
    FormClassPart       form_class;
    AdctoolClassPart    adctool_class;
}                   AdctoolClassRec;

extern AdctoolClassRec adctoolClassRec;

/***************************************
 *
 *  Instance (widget) structure 
 *
 **************************************/

/* New fields for the Adctool widget record */
typedef struct {
    /* resources */
    Widget              child;		/* Graphic part */
    int			channel;	/* which channel */
    int			channel_count;	/* How many channels */
    vdata_t		ac_data;	/* All channel data */
    vdata_t		sc_data;	/* selected channel data */
    Boolean		horiz_scale_on;	/* Horizontal scale on */
    Boolean		vert_scale_on;	/* Vertical scale on */
    Boolean		mark_on;	/* marks on */
    char               *time_series_fn; /* time series file name */
    char               *def_time_series_fn; /* default time series file name */
    char               *def_pitch_fn;   /* default pitch file name */
    char	       *segOutDir;	/* Segment output directory */
    Widget		mark;		/* The (optional) mark widget */
    Widget		hscale;		/* The (optional) hscale widget */
    Widget		vscale;		/* The (optional) vscale widget */
    Widget		scroll;		/* The (optional) scroll widget */
    char               *lyre_label;     /* The label in the tool */
}                   AdctoolPart;


/* Full widget declaration */
typedef struct _AdctoolRec {
    CorePart            core;
    CompositePart       composite;
    ConstraintPart      constraint;
    FormPart            form;
    AdctoolPart         adctool;
}                   AdctoolRec;

typedef struct _AdctoolConstraintsPart
{
    int makes_compiler_happy;	/* not used */
} AdctoolConstraintsPart;

typedef struct _AdctoolConstraintsRec {
    FormConstraintsPart		form;    
    AdctoolConstraintsPart	adctool;
} AdctoolConstraintsRec, *AdctoolConstraints;

#endif _XtAdctoolP_h
