/*
 *
 * $Id: addhdr.c,v 1.11 1993/09/11 19:16:13 johans Exp johans $
 *
 * addhdr - adds an adc file hdr to a raw data file
 *
 * Usage:  addhdr infile outfile sample_rate big|little
 *
 */

/* Standard C library include file directives */
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>

/* Speech Library include file directives */
#include <speech.h>

#define BPS 2                                      /* bytes per sample */
#define BUFFER_STEP 8192

#define BIG	(0)
#define LITTLE	(1)

char InFileName[200]="-";                 /* Input file name / stdin      */
char OutFileName[200]="-";                /* Output file name / stdout    */
int  DataByteOrder=1;                    /* requested data byte ordering */
int  MachineByteOrder;                   /* type of machine ordering     */
int  sample_rate=8000;                   /* sampling rate of data        */


/*
 * usage()
 *
 * display usage paramters on screen
 *
 */

void usage() 
{
  fprintf(stderr, "Usage: <stdin> | addhdr [options] | <stdout>\n");
  fprintf(stderr, "\n");
  fprintf(stderr, "Where options can be any of the following:\n");
  fprintf(stderr, "-f input file name [stdin]\n");
  fprintf(stderr, "-o output file name [stdout]\n");
  fprintf(stderr, "-b big endian byte ordering\n");
  fprintf(stderr, "-l little endian byte ordering\n");
  fprintf(stderr, "-r sampling rate [8000]\n");
  fprintf(stderr, "-h This help message\n");
  exit(1);
}


/*
 * get_comline(int argc, char **argv)
 *
 * read and interpret command line
 *
 */

void get_comline(int argc, char **argv)
{
  int c;
  extern int optind;
  extern char *optarg;

  while( (c = getopt( argc, argv, "f:o:r:blh")) != -1 )
    {
        switch( c )
        {
            case 'f':  /* input file */
                strcpy(InFileName, optarg);
                break;

            case 'o':  /* output file */
		strcpy(OutFileName, optarg);
		break;

            case 'b':/* output file */
                DataByteOrder = BIG;
                break;

            case 'l':/* analysis window in msecs */
		DataByteOrder = LITTLE;
                break;

            case 'r':/* infomation request */
                sample_rate = atoi(optarg);
                break;

	    case 'h': /* help */
            default:
		usage();
                break;
        }
    }
}


void main(int argc, char **argv )
{
  struct stat istat;
  int num_samples;
  FILE  *ifp;
  char  *bp;
  int   c;
  int   buffersize, stepsize;
  
  MachineByteOrder = LittleIndian();
  get_comline(argc, argv);

  if (strcmp(InFileName, "-") == 0) {
    ifp = stdin;
    num_samples = BUFFER_STEP;
    stepsize    = BUFFER_STEP;
  }
  else {
    if( ( ifp = fopen(InFileName, "r")) == NULL ) {
      fprintf( stderr, "addhdr: %s: ", InFileName);
      perror( NULL );
      exit( 1 );
    }

    if( stat(InFileName, &istat) == -1 ) {
      fprintf(stderr, "addhdr: %s: ", argv[1] );
      perror( NULL );
      exit(-1);
    }
    num_samples = istat.st_size / BPS;
    stepsize    = num_samples; 
  }

  buffersize = num_samples;

  /*
   * create output file header
   *
   */

  /* 
   * read data from input file 
   */
  if (!(bp = (char *) malloc(buffersize * BPS)))
    eerror("bp --> malloc failed");
	
  c = 0;
  while (!(feof(ifp))) { 
    c += fread( &bp[c*BPS], sizeof(short), BUFFER_STEP , ifp );
    if (!(bp = (char *) realloc(bp, (buffersize + BUFFER_STEP) * BPS)))
      eerror("bp --> realloc failed");
    buffersize += BUFFER_STEP;
  } 

  num_samples = c;
  if( MachineByteOrder != DataByteOrder ) {
    swab( bp, bp, num_samples * BPS );
  }
  
  /* 
   * write output file header and data 
   */

  if( WavWrite(OutFileName, (short *) bp, num_samples, sample_rate, 0 )<0 ) {
    fprintf( stderr, "addhdr: WavWrite: %s\n", OutFileName, ErrorString );
    exit( 1 );
  }
  
  exit( 0 );
}
