/* file = xutil.c */
/* simple code for using creating and using an window under X */
/* Nigel Ward, University of Tokyo, April 1994; based on code by Minoru Terada */

#include "cheap.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

Display	*display;
Window	win;
XEvent   report;

static int	screen_num;
static Screen	*screen_ptr;
static int	x, y;
static int	border_width=4;
static GC	gc_fore, gc_back, gc_red;
static int	doflush;
static XColor   cdef;

sg_create(width, height, flushflag, name)	char *name;
{
  Colormap default_cmap;

	display = XOpenDisplay(NULL);
	screen_num = DefaultScreen(display);
	screen_ptr = DefaultScreenOfDisplay(display);

	win = XCreateSimpleWindow(
		display,
		RootWindow(display, screen_num),
		x, y,
		width, height,
		border_width,
		BlackPixel(display, screen_num),
		WhitePixel(display, screen_num));

	XStoreName(display,win,name);

	XMapWindow(display, win);

	gc_fore = XCreateGC(display, RootWindow(display, screen_num), 0, NULL);
	XSetForeground(display, gc_fore, BlackPixel(display, screen_num));
	XSetBackground(display, gc_fore, WhitePixel(display, screen_num));

	gc_back = XCreateGC(display, RootWindow(display, screen_num), 0, NULL);
	XSetForeground(display, gc_back, WhitePixel(display, screen_num));
	XSetBackground(display, gc_back, BlackPixel(display, screen_num));

        default_cmap = DefaultColormap(display, screen_num);
	XAllocNamedColor(display, default_cmap, "red3", &cdef, &cdef);
	gc_red = XCreateGC(display, RootWindow(display, screen_num), 0, NULL);
        XSetForeground(display, gc_red, cdef.pixel);
        XSetBackground(display, gc_red, WhitePixel(display, screen_num));

	XFlush(display);

	doflush = flushflag;
}

sg_wait_for_mapping()
{
  XSelectInput(display, win, ExposureMask);
  XNextEvent(display, &report);
  fprintf(stderr, " xutil: mapping occured (report.type = %d)\n", report.type);
}

sg_clear()
{	XClearWindow(display,win);
	if(doflush)XFlush(display);}

sg_line(x0,y0,x1,y1)
{	XDrawLine(display, win, gc_fore, x0, y0, x1, y1);
	if(doflush)XFlush(display);}

sg_line_red(x0,y0,x1,y1)
{	XDrawLine(display, win, gc_red, x0, y0, x1, y1);
	if(doflush)XFlush(display);}

sg_clear_line(x0,y0,x1,y1)
{	XDrawLine(display, win, gc_back, x0, y0, x1, y1);
	if(doflush)XFlush(display);}

sg_string(x, y, s)	char *s;
{	XDrawString(display, win, gc_fore, x, y, s, strlen(s));
	if(doflush)XFlush(display); }

sg_string_red(x, y, s)	char *s;
{	XDrawString(display, win, gc_red, x, y, s, strlen(s));
	if(doflush)XFlush(display); }
sg_clear_string(x, y, s)	char *s;
{	XDrawString(display, win, gc_back, x, y, s, strlen(s));
	if(doflush)XFlush(display); }

sg_pset(x,y)
{	XDrawPoint(display, win, gc_fore, x, y);
	if(doflush)XFlush(display);}

sg_pset_red(x,y)
{	XDrawPoint(display, win, gc_red, x, y);
	if(doflush)XFlush(display);}

sg_preset(x,y)
{	XDrawPoint(display, win, gc_back, x, y);
	if(doflush)XFlush(display);}

sg_draw_rect(x,y,width,height)
{  XFillRectangle(display, win, gc_fore, x, y, width, height);
  if(doflush)XFlush(display);}

sg_erase_rect(x,y,width,height)
{  XFillRectangle(display, win, gc_back, x, y, width, height);
  if(doflush)XFlush(display);}

sg_outline_rect(x,y,width,height)
{  XDrawRectangle(display, win, gc_fore, x, y, width, height);
  if(doflush)XFlush(display);}

sg_clear_outline_rect(x,y,width,height)
{  XFillRectangle(display, win, gc_back, x, y, width, height);
  if(doflush)XFlush(display);}

sg_flush()
{	XFlush(display);}

sg_close()
{	XFreeGC(display,gc_fore);
	XFreeGC(display,gc_back);
	XCloseDisplay(display);}

sg_bell()
{    XBell(display, 100);}


/* display a word hypothesis, its score, and its time span */
/* all dimensions in pixels */
display_span(string, spanx1, spanx2, y, score, underlinep, underlinex1, underlinex2)
     char *string;
     int spanx1, spanx2, y;
     float score;
     int underlinep, underlinex1, underlinex2;
{
  char tmp_string[50];

  sprintf(tmp_string, "%s %.2f", string, score);
  sg_string(spanx1, y, tmp_string);
  sg_line(spanx1, y + 2, spanx2, y + 2);

  if (underlinep) {
    /* sg_line(underlinex1, y + 4, underlinex2, y + 4); */
    XDrawLine(display, win, gc_red, underlinex1, y + 4, underlinex2, y + 4);
    XDrawLine(display, win, gc_red, underlinex1, y + 5, underlinex2, y + 5); }
}

vertical_dots(x, y1, y2)   int x, y1, y2;
{
  int yy;
  for (yy = y1; yy < y2; yy += 8)
    sg_pset(x,yy); }
