/* file = chopper.c */ 
/* chops a sentence audio file into files for each word, as specified by the .la file */
/* Nigel Ward, University of Tokyo, April 1994 */

/* ----------------------------------------------------------------------------- */
#include "cheap.h"
#include <sys/stat.h>

char target_dir[MAX_PATH_LEN];
int active_file;
char file_list[100][MAX_PATH_LEN];
int nfiles;

struct whyp labels[MAX_LABELS];
int nlabels;

static Audio_filehdr	in_hdr;	
char info_string[MAX_INFO_STRING_LEN];
char raw_data[MAX_SAMPLES];
int nsamples; 

/*-----------------------------------------------------------------------------*/

main(argc,argv)      int argc;      char *argv[];
{
  int i;
  struct stat sbuf;

  nfiles = argc - 2;
  if (nfiles <= 0) 
    {chopper_usage(); exit(STRANGE);}
  strcpy(target_dir, argv[1]);
  if (stat(target_dir, &sbuf) < 0) {
    printf(" `%s' not found\n", target_dir);
    chopper_usage();  exit(STRANGE); } 
  if ((sbuf.st_mode & S_IFMT) != S_IFDIR) {
    printf("  `%s' is not a directory\n", target_dir); 
    chopper_usage();  exit(STRANGE); }
  for (i = 2; i < argc; i++)
    strcpy(file_list[i-2], argv[i]);
  for(active_file = 0; active_file < nfiles; active_file++)
    chop_up_file();
  exit(NORMAL);
}

/*-----------------------------------------------------------------------------*/
chopper_usage() {
  fprintf(stderr, "usage: \n");
  fprintf(stderr, "  chopper target_directory au_file1 <au_file>* \n");
  fprintf(stderr, "  (each .au file must have a corresponding .la file)\n"); }

/*-----------------------------------------------------------------------------*/
chop_up_file()
{
  char la_file_name[MAX_PATH_LEN], au_file_name[MAX_PATH_LEN];

  printf("processing file `%s' ... \n", file_list[active_file]);
  make_new_path(la_file_name, file_list[active_file], ".la");
  nlabels = read_label_file(file_list[active_file], labels);
  if (nlabels == 0)
    fprintf(stderr, " ! 0 labels read --- skipping file `%s'", file_list[active_file]);
  make_new_path(au_file_name, file_list[active_file], ".au");
  nsamples =  read_au_into_array(au_file_name, &in_hdr, info_string, raw_data);
  do_each_label();
}

/*-----------------------------------------------------------------------------*/
do_each_label()
{
  int i, exists;
  int first_byte, last_byte, byte_count;
  char new_filename[MAX_PATH_LEN], basename[MAX_PATH_LEN];
  char new_info_string[MAX_INFO_STRING_LEN]; 
  int out_fd;
  struct stat st;

  for (i = 0; i < nlabels; i++) {

    /* assemble output filename, for example, pathname/john-fm-sentence2.au */
    strcpy(new_filename, target_dir);
    strcat(new_filename, "/");
    strcat(new_filename, labels[i].label);
    strcat(new_filename, "-fm-");
    basefilename(basename, file_list[active_file]);
    strcat(new_filename, basename);
    strcat(new_filename, ".au");
  
    printf(" writing to file `%s'\n", new_filename);
    exists = (stat(new_filename, &st) == 0);
    if (exists) {
      /* might be better _NOT_ to overwrite files */
      printf("  Warning: overwriting !!\n"); }
    
    out_fd = open(new_filename, O_WRONLY | O_CREAT | O_TRUNC, 0644); 
    if (out_fd == -1) {
      fprintf(stderr, "*** open failed ***\n");
      break; }

    first_byte = labels[i].start * SAMPLES_PER_MS;
    last_byte =  labels[i].end   * SAMPLES_PER_MS;
    byte_count = last_byte - first_byte;

    strcpy(new_info_string, labels[i].label); 
    strcat(new_info_string, "-fm-");
    if (strcmp(info_string, "") == 0 ||
	strcmp(info_string, "recorded-by-grab") == 0)
      strcat(new_info_string, basename);
    else 
      strcat(new_info_string, info_string);

    write_audio_hdr(out_fd, new_info_string, byte_count,
		    in_hdr.encoding, in_hdr.sample_rate, in_hdr.channels);
    (void) write(out_fd, raw_data+first_byte, byte_count);

    close(out_fd);
  }
}


/*-----------------------------------------------------------------------------*/


