/*
  title:    sp_callbacks.c (callback routines for XView widgets).
  purpose:  To display two and three dimensional projections of speech
    trajectories through a high dimensional filter-band space.  With
    bindings to an Xview interface defined in xv_interface.c.

  author:   Gareth Lee.
  date:     16-08-93
  modified: 14-09-93

  Copyright (C) 1994 Gareth Lee.
     
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  changes:
*/

/*****************************************************************************/

/* Prototypes for callback routines */
void SampleDismissCallback(void);
void SampleListnameCallback(Panel_item item, Event *event);
void SampleOptionsCallback(Panel_item item, int flags, Event *event);
void SampleWinStateCallback(Panel_item item);
int  SampleListCallback(Panel_item item, char* string, Xv_opaque client_data,
                        Panel_list_op op, Event* event, int row);
void SamplesCallback(void);
int SampleFormatCallback(Panel_item item, char* string,
                         Xv_opaque client_data, Panel_list_op op,
                         Event* event, int row);
int SampleFrontendCallback(Panel_item item, char* string,
                           Xv_opaque client_data, Panel_list_op op,
                           Event* event, int row);
void SampleUpdateCallback(void);
void SampleParamsCallback(void);
int ParamsFormatCallback(Panel_item item, char* string,
                         Xv_opaque client_data, Panel_list_op op,
                         Event* event, int row);
int ParamsFrontendCallback(Panel_item item, char* string,
                         Xv_opaque client_data, Panel_list_op op,
                         Event* event, int row);
void ParamsFormatTextCallback(Panel_item item, Event event);
void ParamsFrontendTextCallback(Panel_item item, Event event);
void ParamsDismissCallback(void);
void Rotation1Callback(Panel_item item, int value, Event *event);
void Rotation2Callback(Panel_item item, int value, Event *event);
void AnimateCallback(void);
void AngleSliderCallback(Panel_item item, int value, Event *event);
void IterationSliderCallback(Panel_item item, int value, Event *event);
void ViewSliderCallback(void);
void AutoCallback(void);
void ThreeDimSelectorCallback(Panel_item item, int value, Event *event);
void SpecifyCallback(void);
void SpecifyModeCallback(Panel_item item, int value, Event *event);
void SpecifyEigenCallback(Panel_item item, int value, Event* event);
void SpecifyToggleCallback(Panel_item, int, Event*);
void SpecifyDismissCallback(void);
void SpecifyAnalyseCallback(void);
void SpecifyProjectCallback(void);
void HighlightCallback(void);
void QuitCallback(void);
void HighlightSliderCallback(Panel_item item, int value, Event *event);
void HighlightSelectorCallback(Panel_item item, int value, Event *event);
void HighlightDismissCallback(void);
void DisplaySliderCallback(Panel_item item, int value, Event *event);
void DisplayCheckBoxCallback(void);
void DisplayRandomizeCallback(void);
void DisplayStoreRecallCallback(Panel_item item, Event *event);
void DisplayFormatCallback(Panel_item item, int value, Event *event);
void DisplayArrowCallback(Panel_item item, Event *event);
void DisplayDismissCallback(void);
void DisplayEventHandler(Xv_Window window, Event *event);
void DisplayColorsCallback(void);
void SweepGraphicsCallback();
void PointSetCallback(void);

/* Work Procedures to be run outside xv_main_loop() */
void SampleUpdateWorkProc(void);

/*****************************************************************************/

/* end of sp_callbacks.h */
