static char SccsID[] = "@(#)preemp.c	1.6   7/17/91";
/*
  Copyright (C) 1994 Edmund Lai.
     
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*	Speech Signal Processing Software Library
 *
 *	=== PREEMP.C ===
 *
 *	Pre-emphasis filtering.
 *				   -1
 *		H(z) = 1 - beta * z
 *
 *	Edmund Lai
 *	Department of Electrical and Electronic Engineering
 *	University of Western Australia.
 *
 */


/*	void pre_emphasis (int,double,double *,double *);
 *
 *	n	: Number of samples in the input sequence.
 *	beta	: The pre-emphasis constant.
 *	x	: Input sample sequence.
 *	y	: Pre-emphasized output sample sequence.
 *		  y[0] = x[0] (unchanged).
 *
 */
void pre_emphasis (n,beta,x,y)
int	n;
double	beta;
double	x[],y[];
{
	int	i;
	
	y[0] = x[0];
	for (i = 1; i < n; i++)  y[i] = x[i] - (beta * x[i-1]);
}


/* In-place version of the pre-emphasis function */
void preemp_short (n,beta,x)
int	n;
double	beta;
short	*x;
{
	int	i;

	for (i = 1; i < n; i++) {
		*x = *x - (short)(*(x-1) * beta);
		x++;
	}
}

/* In-place version of the pre-emphasis function */
void preemp_char (n,beta,x)
int	n;
double	beta;
signed char	*x;
{
	int	i;

	for (i = 1; i < n; i++) {
		*x = *x - (signed char)(*(x-1) * beta);
		x++;
	}
}
