/*
  title:    fview_io.h
  purpose:  Standard header record for interface to the fview program.
  
  author:   Gareth Lee.
  date:     21-10-93
  modified: 11-02-94

  Copyright (C) 1994 Gareth Lee.
     
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  changes:
  11-02-94: `logged' field added to the FviewFeatureHeader to allow front-end
    processes to indicate whether the features being provided are in a
    logarithmic or linear form.  This can be used by fview when allowing user
    controlled compression/decompression of the features during display.
*/

/* Magic numbers to verify compliance to correct formats */
#define FVIEW_SAMPLE_MAGIC  "fview2sh"
#define FVIEW_FEATURE_MAGIC "fview2fh"

/* Legitimate values for the FviewFeatureHeader.logged field */
#define FVIEW_FEAT_LINEAR     (0)
#define FVIEW_FEAT_UNKNOWN    (1)
#define FVIEW_FEAT_LOGGED     (2)

/* Unset value for the colour preference field */
#define FVIEW_COLR_NOPREF     (0)

/*
  FviewSampleHeader: a 128 byte Header record that all fview format converters
    must generate as output.
*/
typedef struct {

  char     magic[8];                                         /* magic number */
  unsigned number_samples;      /* number of 16 bit two's compliment samples */
  unsigned sample_freq;                            /* sample frequency in Hz */
  unsigned info_size;     /* size of additional information on the utterance */

} FviewSampleHeader;

/* FviewFeatureHeader: a 128 byte Header record that all fview filters must
     generate as output.
*/
typedef struct {
  
  char     magic[8];                                         /* magic number */
  unsigned vector_dimension;     /* num elements forming each feature vector */
  unsigned number_observations;      /* num feature vectors in the utterance */
  unsigned info_size;     /* size of additional information on the utterance */
  unsigned logged;  /* indicates feature values are in a log-compressed form */
  unsigned color_preference;          /* colour preference (or zero if none) */

} FviewFeatureHeader;

