/*
  title: fview.h
  purpose: Header file for fview.c

  author:   Gareth Lee.
  date:     16-08-93
  modified: 01-04-94

  Copyright (C) 1994 Gareth Lee.
     
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  changes:
  01-04-94: DEFAULT_PATH_NAME string set to something more useful.  
*/

#if !defined SUNOS && !defined LINUX
#error Must define environment (see Makefile)
#endif

#ifndef REAL
#error Must define REAL number type (see Makefile)
#endif

/* This version of the executable */
#ifdef LINUX
#define FVIEW_VERSION "1.2 (Linux, beta)"
#endif
#ifdef SUNOS
#define FVIEW_VERSION "1.2 (SunOS, beta)"
#endif

/* These determine projection variables*/
#define MAX_SAMPLES 10   /* Max # of trajs that may be viewed simultaneously */
#define MIN_DIMENSION 3     /* Minimum number of feature dimensions accepted */
#define MAX_DIMENSION 20    /* Maximum number of feature dimensions accepted */
#define ITERATIONS 200                        /* Number of initial rotations */
#define ROTATION_DIM1 0                           /* Initial first dimension */
#define ROTATION_DIM2 1                          /* Initial second dimension */
#define ANGLE 0.01                              /* Initial angle of rotation */
#define INIT1 1                     /* Initial first window vector dimension */
#define INIT2 2                    /* Initial second window vector dimension */

#define MAX_LIST_LENGTH (1024) /* num entries that can be read from listfile */

#define SIZE_OFFSET        (0)                      /* default offset values */
#define UP_DOWN_OFFSET     (0)
#define LEFT_RIGHT_OFFSET  (0)

#define FORMAT_FILE_NAME   "Formats"
#define FRONTEND_FILE_NAME "Frontends"

#define DEF_FORMAT_FILTER "fview (*.fvw)"
#define DEF_FRONTEND_FILTER "None"

#define DEFAULT_LIST_NAME "list"
#define DEFAULT_PATH_NAME ".:./drivers:./lists"

#define ENVIRONMENT_PATH_NAME  "FVIEWPATH"
#define ENVIRONMENT_COLOR_NAME "FVIEWCOLOR"

#define FORMAT_SAMPLE  (1)
#define FORMAT_FEATURE (2)

#define SPECTRUM_SIZE (16)

#ifndef LINUX
/* prototypes */
void srandom(int);                           /* seed random number generator */
long random(void);                        /* invoke random  number generator */
#endif

#define drandom() (((real) random()) / 2147483647.0)

/* Type definitions */
typedef struct
{
  real **point;
  unsigned logged;                       /* indicated data values are logged */
  int npoints;
  char *file_name;
  int file_name_length;

  /* projection of trajectory into 3D space */
  real *project1, *project2, *project3;

  int    row;              /* index of list_names[] entry for this structure */
  int    nverts;           /* number of vertices with segmentation decisions */
  int   *order;                                    /* segmentation decisions */
  real  *dist;                              /* prediction errors for each pt */
  real **data;                                 /* raw data without expansion */
  real   min_datum;                 /* minimum value of any (raw) data point */
  real   max_datum;                                         /* maximum value */

  int    ptset;      /* selects that data should be displayed as a point set */
  XRectangle label_box;       /* box in which the file name has been written */
  int    color_key;         /* preference regarding color to use for drawing */
  int    color;                  /* color to use for drawing this trajectory */

} SpeechRecord;

typedef struct _option_record {
  char *name;                                              /* name of option */
  char *command;                                 /* name of command flag etc */
  char *value;                               /* default value for the option */
  struct _option_record *next;                        /* next option in list */
  int index;                        /* index of option within scrolling list */
} OptionRecord;

typedef struct _filter_record {
  char *name;                        /* name to display in the Selector List */
  char *program;                    /* program name when invoking the filter */
  char *path;              /* directory in which the filter has been located */
  char format;                        /* input/output file format for filter */
  char *def_list;                                  /* default list file name */
  int index;                        /* index of option within scrolling list */
  struct _option_record *options;  /* List of options associated with filter */
  struct _filter_record *next;                        /* next filter in list */
} FilterRecord;

/* Three display modes */
typedef enum {two_dims, three_dims, spectrogram} DisplayMode;

/* Work Procedure type */
typedef void (*WorkProc)(void);

extern int dimension;
extern char *progname;
extern Display *display;
extern int screen_num;
extern Window win;
extern GC gc;
extern unsigned int width, height;
extern int rotation_dim1;
extern int rotation_dim2;
extern int iterations;
extern int samples;
extern real angle;
extern real *w1, *w2, *w3;
extern real *stw1, *stw2, *stw3;
extern SpeechRecord *spdata[MAX_SAMPLES];
extern int size;
extern int up_down;
extern int left_right;
extern DisplayMode display_mode;
extern WorkProc ExecWorkProc;
extern int utterance_index;
extern int highlighted;
extern int max_vertices;
extern int auto_scale;
extern char *list_fname;
extern char *list_fpath;
extern int list_entries;
extern char* list_names[MAX_LIST_LENGTH];
extern int sample_display_info;
extern int sample_assume_logged;
extern int compress_raw_mode;
extern int compress_scale_mode;
extern real compress_alpha;
extern int display_label_mode;
extern int display_origin_mode;
extern int global_ptset_mode;
extern int spectrogram_stretch_mode;
extern int spectrogram_energy_mode;
extern FilterRecord Formats;
extern FilterRecord Frontends;
extern FilterRecord *FormatFilter;
extern FilterRecord *FrontendFilter;
extern char *SearchPath[1024];
extern char *ColorString;
extern real CompressionMinValue;
extern real CompressionMaxValue;

/* prototypes for functions in fview.c */
void Initialize(char *list_name, char *list_path);
void RefreshGraphics(void);
int  OpenDataFile(char *filename, SpeechRecord *sd, int verbose);
void Projection(void);
void Quit(int code);
char *StringDup(char *source);

/* defined in interface.c */
extern XColor traj_color[MAX_COLORS];
extern XColor spec_color[SPECTRUM_SIZE];
extern XColor dim3_defs[4];
extern XColor dim3_color[16];

/* prototypes */
extern void CompressionRange(int samps);
extern void Compression(SpeechRecord *sd, real alpha);

/* end of sp_proj3.h */

