#define ALEN 32
#define SHORT 2
#define mmin(A,B)      ((A)<(B)?(A):(B))
#define mmax(A,B)      ((A)>(B)?(A):(B))
#include <stdio.h>
#include <math.h>
#include <sys/file.h>

main(argc, argv)
int argc;
char *argv[];
{ 

  int i, j, maxd, ns;
  int read_file1, read_file2, write_file3;
  int n_read1, n_read2, n_write3;
  short ia[ALEN], ib[ALEN];
  float rms;
  char input_file1[100], input_file2[100], output_file[100];


  if (argc < 3 || argc > 4)
  {
    printf("Usage error: sub infile1 infile2 [outfile]\n                 (outfile = infile1 - infile2)\n");
  exit(0);
  }
  strcpy(input_file1, argv[1]);
  strcpy(input_file2, argv[2]);
  read_file1 = open(input_file1, O_RDONLY, 0);
  if (read_file1 < 0)
  {
    perror("ERROR opening the first input file for reading");
    exit(0);
  }
  read_file2 = open(input_file2, O_RDONLY, 0);
  if (read_file2 < 0)
  {
    perror("ERROR opening the second input file for reading");
    exit(0);
  }
  if (argc == 4)
  {
    strcpy(output_file, argv[3]);
    write_file3 = open(output_file, O_WRONLY|O_CREAT, 0644);
    if (write_file3 < 0)
    {
      perror("ERROR opening the output file for writing");
      exit(0);
    }
  }

  maxd = 0;
  rms = 0.0;
  n_read1 = read(read_file1, ia, ALEN*SHORT);
  n_read2 = read(read_file2, ib, ALEN*SHORT);
  while (n_read1 != 0 && n_read2 != 0)
  {
    for (i = 0; i < ALEN; i++)
    {
      j = ia[i] - ib[i];
      maxd = mmax(maxd, abs(j));
      rms = rms + j * j;
      ia[i] = mmax(mmin(j, 32767), -32768);
    }
    if (argc == 4)
    {
      n_write3 = write(write_file3, ia, ALEN*SHORT);
      if(n_write3 < 0)
      {
        perror("ERROR writing the output file");
        exit(0);
      }
    }
    ns = ns + ALEN;
    n_read1 = read(read_file1, ia, ALEN*SHORT);
    if(n_read1 < 0)
    {
       perror("ERROR reading the first input file");
       exit(0);
    }
    n_read2 = read(read_file2, ib, ALEN*SHORT);
    if(n_read2 < 0)
    {
      perror("ERROR reading the second input file");
      exit(0);
    }
  }
  if (ns < 0)
  {
    printf("No Samples\n");
    exit(0);
  }
  if (maxd <= 0)
  {
    printf("No Differences\n");
    exit(0);
  }
  printf("    %d samples, RMS dif = %6.2f, Max diff = %d\n", ns, sqrt(rms/ns), maxd);

}

