/*  ----------------------  DATA FILE WRITE ROUTINES  ----------------------  */
/*  -----------------------  Sun FORTRAN Interface  ------------------------  */
/*  ------------------  Interface Version 1.0   May 1988  ------------------  *
/*  ------------------------------------------------------------------------  */
#include "diskio.h"
/*  -------------------------  OPEN FILE ROUTINE  -------------------------  */

open_file_ ( filename, open_type_p, fn_leng )

char filename[];
int *open_type_p, fn_leng;

{
   char *add_null();
   return( open_file(add_null(filename, fn_leng), *open_type_p) );
}

/*  ----------------------  DEFINE VARIABLE ROUTINE  ----------------------  */

def_variable_ ( file_id_p, name, type_p, number_p, def_val, name_leng )

char name[], def_val[];
int *file_id_p, *type_p, *number_p, name_leng;

{
   char *add_null();
   return( def_variable(*file_id_p, add_null(name, name_leng), *type_p, *number_p, def_val) );
}

/*  -----------------------  SAVE VARIABLE ROUTINE  -----------------------  */

save_variable_ ( var_id_p, values, num_p )

char values[];
int *var_id_p, *num_p;

{
   return( save_variable(*var_id_p, values, *num_p) );
}

/*  -------------------------  END BLOCK ROUTINE  -------------------------  */

end_block_ ( file_id_p )

int *file_id_p;

{
   return( end_block(*file_id_p) );
}

/*  -------------------------  CLOSE FILE ROUTINE  -------------------------  */

close_file_ ( file_id_p )

int *file_id_p;

{
   return( close_file(*file_id_p) );
}

/*  ---------------------  DISK WRITE ERROR ROUTINES  ---------------------  */

print_disk_write_error_ ( err_num_p )

int *err_num_p;

{
   print_disk_write_error(*err_num_p);
   return;
}

/*  ------------------------------  add_null  ------------------------------  */

#define MAX_STRING_LENGTH   100

static char *add_null(string, length)

char string[];
int length;

{
   static char ts[MAX_STRING_LENGTH + 1];
   int i;

   if (length > MAX_STRING_LENGTH) length = MAX_STRING_LENGTH;
   for (i=0; i<length; i++) ts[i] = string[i]; /* copy input string */
   ts[length] = '\0';               /* and terminate it with a null */
   i = length - 1;      /* start at end of string */
   while (ts[i] == ' ') ts[i--] = '\0';  /* change trailing blanks to nulls */
   return(ts);
}
