/**************************************************************************
*
* ROUTINE
*		vdecode
*
* FUNCTION
*
*		create excitation vector from code book index and decoded gain
*
* SYNOPSIS
*		subroutine vdecode(decodedgain, l, vdecoded)
*
*   formal
*
*                       data    I/O
*       name            type    type    function
*       -------------------------------------------------------------------
*	decodedgain	r	i	decoded gain value
*	l		i	i	pitch&code frame length
*	vdecoded	r	o	decoded excitation array
*
*   external
*                       data    I/O
*       name            type    type    function
*       -------------------------------------------------------------------
*       x[]		float	i
*
***************************************************************************
*
* CALLED BY
*
*       celp
*
* CALLS
*
*
*
**************************************************************************/
#include "ccsub.h"
extern int cbindex, frame;
extern float x[MAXCODE];

vdecode(decodedgain, l, vdecoded)
int l;
float decodedgain, vdecoded[];

{
  int i, codeword;

  /* *copy selected vector to excitation array	 		 	 */

  codeword = 2 * (MAXNCSIZE - cbindex);
  if (codeword < 0)
  {
    printf("vdecode: cbindex > MAXNCSIZE at frame %d\n", frame);
    codeword = 0;
  }
  for (i = 0; i < l; i++)
    vdecoded[i] = x[i + codeword] * decodedgain;
}
