/**************************************************************************
*
* ROUTINE
*               specdist
*
* FUNCTION
*
*               Computes spectral distorion caused by quantization of
*		line spectral frequencies.
*
* SYNOPSIS
*
*		subroutine specdist(fcn, newfreq, dm, sumdm, iframedm)
*
*   formal
*
*                       data    I/O
*       name            type    type    function
*       -------------------------------------------------------------------
*	fcn		float	i	unquantized predictor coefficients
*	newfreq		float	i	quantized line spectral frequencies
*	dm		float	o	distortion array (subframe)
*	sumdm		float	o	distortion array (current sum)
*	iframedm	int	o	number of subframes
*
*   external
*                       data    I/O
*       name            type    type    function
*       -------------------------------------------------------------------
*       no		int     i
*
***************************************************************************
*
* DESCRIPTION
*
*	Calculate distortions/distances (log spectral error, etc.).
*	See the first reference below for a complete description.  A
*	"reference" system is compared against a "test" system.  Because
*	of the nonsymetric nature of the Itakura-Saito measure which some
*	of these distortion measures are based, poorer measures will be
*	obtained if the "reference" and "test" systems are reversed.
*	Because of gain uncertainties, a few measures are reported.
*	(Peter Kroon generally uses the measure DM(4).)
*
***************************************************************************
*
* CALLED BY
*
*	celp
*
* CALLS
*
*	dist   lsptopc   pctorc   rctoac
*
***************************************************************************
*
* REFERENCES
*
*	"Distance Measures for Speech Processing", A.h. Gray and J.D. Markel,
*	IEEE Trans. on ASSP, Vol. ASSP-24, no. 5, Oct. 1976
*
*	"Quantization and Bit Allocation in Speech Processing",
*	A.h. Gray and J.D. Markel,IEEE Trans. on ASSP, Vol. ASSP-24
*	no. 6, Dec. 1976
*
*	"A Note on Quantization and Bit Allocation in Speech Processing",
*	A.h. Gray and J.D. Markel,IEEE Trans. on ASSP, Vol. ASSP-25
*	no. 3, June 1977
*
**************************************************************************/
#include "ccsub.h"
extern int no;

specdist(fcn, newfreq, dm, sumdm, iframedm)
float fcn[], newfreq[], dm[], sumdm[];
int *iframedm;

{
  float newpc[MAXNO + 1], unqac[MAXNO + 1];
  float newac[MAXNO + 1], unqrc[MAXNO], newrc[MAXNO];

  /* Convert LSP's to autocorrelation coefficients for input to "dist" 	 */

  lsptopc(newfreq, newpc);
  pctorc(fcn, unqrc, no);
  pctorc(newpc, newrc, no);
  rctoac(unqrc, unqac, no);
  rctoac(newrc, newac, no);

  /* find distances between the ac sequences 				 */

  dist(no, 4 * no, unqac, newac, dm, sumdm, iframedm);
}
