/*==========================================================================
*
*		 SUNGRAPH OPEN FILE AND DEFINE VARIABLE 
*
*===========================================================================
*
*	*** SUNGRAPH FILES AND VARIABLES
*
*	ifile.spd		   input file
*
*	ifile_ofile.sg_data	   input and output file 
*				   'ifile' 'ifile_hp' 'ofile_npf' 'ofile_pf'
*				   'ofile_hpf'
*
*	channel.sg_data		   4800 bps bit stream
*				   'stream'
*
*	stream_error.sg_data	   4800 bps bit stream with errors
*				   'stream' 'stream_error' 'stream_error_s' 
*				   'error'
*
*	lsp1.sg_data		   line spectral pairs file on a frame basis
*				   comparing unquantized and quantized
*	 			   'lsp 1' 'lsp 2' ... 'lsp10' ...
*				   'qlsp 1' ...  'qlsp10'
*				   'qslsp 1' ... 'qslsp10'
*
*	lsp2.sg_data		   line spectral pairs file on a subframe
*				   basis comparing analysis and synthesis
*				   'lsp_analy 1' 'lsp_analy 2' ...
*				   'lsp_synth 1' 'lsp_synth 2' ...
*
*	pitch.sg_data		    pitch variables 
*				    'match' 'tau' tau_synth' 'ir'
*				    'gain' 'qgain' 'qgain_synth'
*
*	constrain.sg_data	   constrained excitation data
*				   'gain', 'ccor', 'dbcon'
*
*	codebook.sg_data	   codebook variables
*				   'match' 'index' 'index_synth' 'exc' 'ir'
*				   'gain' 'qgain' 'qgain_synth'
*
*	error.sg_data		    error signals
*				    'fndpp_e0' 'fndpp_v0' 'fndex_e0'
*
*	rc.sg_data		    reflection coeficients
*				    'rc 1' 'rc2' ... 'rc10' ...
*
*=======================================================================*/

  /*	*** open files and define variables in sungraph format		*/  
    
    
  /*			* disable disk_io auto error reporting		*/  
    
  disk_io_erh(0);  
    
  /*			* open input speech file			*/  
    
  input_fid = open_var_channel(ifile,"speech_data");  
  if (input_fid < 0) 
    read_error(input_fid, "open input_fid");
    
  /*		* open input_output speech file (4 variables)		*/  
    
     
  ifile_ofile_fid = open_file("ifile_ofile", 1);  
  if (ifile_ofile_fid < 0)  
    write_error(ifile_ofile_fid, "open ifile_ofile_fid");  
    
  /*		* define input_output speech variables			*/  
    
  ifile_vid = def_variable(ifile_ofile_fid, "ifile", R4, ll, &s_zero);  
  if (ifile_vid < 0)  
    write_error(ifile_vid, "define ifile_vid");  

  ifile_hp_vid = def_variable(ifile_ofile_fid, "ifile_hp", R4, ll, &f_zero);  
  if (ifile_hp_vid < 0)  
    write_error(ifile_hp_vid, "define ifile_hp_vid"); 
 
  ofile_npf_vid = def_variable(ifile_ofile_fid, "ofile_npf",I2,ll,&s_zero);  
  if (ofile_npf_vid < 0)  
    write_error(ofile_npf_vid, "define ofile_npf_vid");  

  ofile_pf_vid = def_variable(ifile_ofile_fid, "ofile_pf", I2, ll, &s_zero);  
  if (ofile_pf_vid < 0)  
    write_error(ofile_pf_vid, "define ofile_pf_vid");  

  ofile_hpf_vid = def_variable(ifile_ofile_fid, "ofile_hpf", I2, ll, &s_zero);  
  if (ofile_hpf_vid < 0)  
    write_error(ofile_hpf_vid, "define ofile_hpf_vid");
        
  /*			* open channel file				*/  
    
  channel_fid = open_file("channel", 1);  
  if (channel_fid < 0)  
    write_error(channel_fid, "open channel_fid");  
    
  /*			* define channel variable			*/  
      
  channel_vid = def_variable(channel_fid, "stream", 1, STREAMBITS, &s_zero);  
  if (channel_vid < 0)  
    write_error(channel_vid, "define channel_vid");  
    
  /*			* open stream_error file			*/  
      
  stream_error_fid = open_file("stream_error", 1);  
  if (stream_error_fid < 0)  
    write_error(stream_error_fid, "open stream_error_fid");  
    
  /*			* define stream_error variables			*/  
      
  stream_vid = def_variable(stream_error_fid, 
                          "stream", 1, STREAMBITS, &s_zero);  
  if (stream_vid < 0)  
    write_error(stream_vid, "define stream_vid");  

  stream_error_vid = def_variable(stream_error_fid, 
                         "stream_error", 1, STREAMBITS, &s_zero);  
  if (stream_error_vid < 0)  
    write_error(stream_error_vid, "define stream_error_vid"); 
 
  stream_error_s_vid = def_variable(stream_error_fid,
                         "stream_error_s", 1, STREAMBITS, &s_zero);  
  if (stream_error_s_vid < 0)  
    write_error(stream_error_s_vid, "define stream_error_s_vid");  

  bit_error_vid = def_variable(stream_error_fid,
                         "bit_error", 1, STREAMBITS, &s_zero);  
  if (bit_error_vid < 0)  
    write_error(bit_error_vid, "define bit_error_vid");  
    
  /*		* open lsp1 file (number of variables  =  order)	*/  
      
  lsp1_fid = open_file("lsp1", 1);  
  if (lsp1_fid < 0)  
    write_error(lsp1_fid, "open lsp1_fid");  
   
  /*		* define lsp and qlsp variables 			*/  
      
  for (i = 0; i < no; i++)  
  {  
    sprintf(str,"lsp%2d",i+1);  
    lsp_vid[i] = def_variable(lsp1_fid, str, R4, 1, &f_zero);  
    if (lsp_vid[i] < 0)  
      write_error(lsp_vid[i], "define lsp_vid");  
    sprintf(str,"qlsp%2d",i+1);  
    qlsp_vid[i] = def_variable(lsp1_fid, str, R4, 1, &f_zero);  
    if (qlsp_vid[i] < 0)  
      write_error(qlsp_vid[i], "define qlsp_vid");  
  }  
    
  /*		* open lsp2 file (number of variables  =  order)	*/  
      
  lsp2_fid = open_file("lsp2" ,1);  
  if (lsp2_fid < 0)  
    write_error(lsp2_fid, "open lsp2_fid");  
    
  /*		* define qlsp variables					*/  
      
  for (i = 0; i < no; i++)  
  {  
    sprintf(str,"lsp_analy%2d",i+1);  
    lsp_analy_vid[i] = def_variable(lsp2_fid, str, R4, nn, &f_zero);  
    if (lsp_analy_vid[i] < 0)  
      write_error(lsp_analy_vid[i], "define lsp_analy_vid");  
    sprintf(str,"lsp_synth%2d",i+1);  
    lsp_synth_vid[i] = def_variable(lsp2_fid, str, R4, nn, &f_zero);  
    if (lsp_synth_vid[i] < 0)  
      write_error(lsp_synth_vid[i], "define lsp_synth_vid");  
  }  
   
  /*		*open pitch file					*/  
      
  pitch_fid = open_file("pitch", 1);  
  if (pitch_fid < 0)  
    write_error(pitch_fid, "open pitch_fid");  
    
  /*		*define pitch variables					*/  
      
  pitch_match_vid = def_variable(pitch_fid,
      "match", R4, nn*plevel1, &f_zero);  
  if (pitch_match_vid < 0)  
    write_error(pitch_match_vid, "define pitch_match_vid");  

  pitch_tau_vid = def_variable(pitch_fid,
      "tau" , R4, nn, &s_zero);  
  if (pitch_tau_vid < 0)  
    write_error(pitch_tau_vid, "define pitch_tau_vid");  

  pitch_tau_synth_vid = def_variable(pitch_fid,
      "tau_synth", R4, nn, &s_zero);  
  if (pitch_tau_synth_vid < 0)  
    write_error (pitch_tau_synth_vid,"define pitch_tau_synth_vid"); 
 
  pitch_gain_vid = def_variable(pitch_fid,
      "gain", R4, nn, &f_zero);  
  if (pitch_gain_vid < 0)  
    write_error(pitch_gain_vid, "define pitch_gain_vid");  

  pitch_qgain_vid = def_variable(pitch_fid,
      "qgain", R4, nn, &f_zero);  
  if (pitch_qgain_vid < 0)  
    write_error(pitch_qgain_vid, "define pitch_qgain_vid");  

  pitch_qgain_synth_vid = def_variable(pitch_fid,
      "qgain_synth", R4, nn, &f_zero);  
  if (pitch_qgain_synth_vid < 0)  
    write_error(pitch_qgain_synth_vid, "define pitch_qgain_synth_vid");  

  pitch_ir_vid = def_variable(pitch_fid,
      "ir", R4, ll, &f_zero);  
  if (pitch_ir_vid < 0)  
    write_error(pitch_ir_vid, "define pitch_ir_vid");  
    
  /* 		*open constrain file					*/

  constrain_fid = open_file("constrain", 1);
  if (constrain_fid < 0)
    write_error(constrain_fid, "open constrain_fid");

  /* 		*define constrain variables				*/

  gain_vid = def_variable(constrain_fid, "gain", R4, nn, &f_zero);
  if (gain_vid < 0)
    write_error(gain_vid, "define gain_vid");
  ccor_vid = def_variable(constrain_fid, "ccor", R4, nn, &s_zero);
  if (ccor_vid < 0)
    write_error(ccor_vid, "define ccor_vid");
  dbcon_vid = def_variable(constrain_fid, "dbcon", R4, nn, &s_zero);
  if (dbcon_vid < 0)
    write_error(dbcon_vid, "define dbcon_vid");

  /*		*open codebook file					*/  
      
  cb_fid = open_file("codebook", 1);  
  if (cb_fid < 0)  
    write_error(cb_fid, "open cb_fid");  
      
  /*		*define codebook variables				*/  
      
  cb_match_vid = def_variable(cb_fid, "match", R4, nn*ncsize, &f_zero);  
  if (cb_match_vid < 0)  
    write_error(cb_match_vid, "define cb_match_vid");  

  cb_index_vid = def_variable(cb_fid, "index", 2, nn, &s_zero);  
  if (cb_index_vid < 0)  
    write_error(cb_index_vid, "define cb_index_vid");  

  cb_index_synth_vid = def_variable(cb_fid, "index_synth", 2, nn, &s_zero);  
  if (cb_index_synth_vid < 0)  
    write_error(cb_index_synth_vid, "define cb_index_synth_vid"); 
 
  cb_gain_vid = def_variable(cb_fid, "gain", R4, nn, &f_zero);  
  if (cb_gain_vid < 0)  
    write_error(cb_gain_vid, "define cb_gain_vid"); 
 
  cb_qgain_vid = def_variable(cb_fid, "qgain", R4, nn, &f_zero);  
  if (cb_qgain_vid < 0)  
    write_error(cb_qgain_vid, "define cb_qgain_vid"); 
 
  cb_qgain_synth_vid = def_variable(cb_fid, "qgain_synth", R4, nn, &f_zero);  
  if (cb_qgain_synth_vid < 0)  
    write_error(cb_qgain_synth_vid, "define cb_qgain_synth_vid");  

  cb_exc_vid = def_variable(cb_fid, "exc", R4, ll, &f_zero);  
  if (cb_exc_vid < 0)  
    write_error (cb_exc_vid, "define cb_exc_vid");  

  cb_ir_vid = def_variable(cb_fid, "ir", R4, ll, &f_zero);  
  if (cb_ir_vid < 0)  
    write_error(cb_ir_vid, "define cb_ir_vid"); 
 
   /*		*open error file					*/  
      
  error_fid = open_file("error", 1);  
  if (error_fid < 0)  
    write_error(error_fid, "open error_fid");  
    
  /*		*define error variables					*/  
      
  fndpp_v0_vid = def_variable(error_fid, "fndpp_v0", R4, ll, &f_zero);  
  if (fndpp_v0_vid < 0)  
    write_error(fndpp_v0_vid, "define fndpp_v0_vid");  

  fndpp_e0_vid = def_variable(error_fid, "fndpp_e0", R4, ll, &f_zero);  
  if (fndpp_e0_vid < 0)  
    write_error(fndpp_e0_vid, "define fndpp_e0_vid");  

  fndex_e0_vid = def_variable(error_fid, "fndex_e0", R4, ll, &f_zero);  
  if (fndex_e0_vid < 0)  
    write_error(fndex_e0_vid, "define fndex_e0_vid");  
    
  /*		*open reflection coefficient file			*/  
      
  rc_fid = open_file("rc", 1);  
  if (rc_fid < 0)  
    write_error(rc_fid, "open rc_fid");  
    
  /*		*define rc variables					*/  
      
  for (i = 0; i < no; i++)  
  {  
    sprintf(str,"rc%2d",i+1);  
    rc_vid[i] = def_variable(rc_fid, str, R4, 1, &f_zero);  
     if (rc_vid[i] < 0)  
       write_error(rc_vid[i], "define rc_vid");  
  }   
