/**************************************************************************
*
* ROUTINE
*		RANDOM2 (LPC-10e Version 49)
*
* FUNCTION
*
*		Pseudo random number generator.
*
* SYNOPSIS
*		function random2()
*
*   formal 
*                       data    I/O
*       name            type    type    function
*       -------------------------------------------------------------------
*	random2		i	fun	uniformly distributed
*					over -32768 to 32767
***************************************************************************
*	
* DESCRIPTION
*
*	See reference.
*
***************************************************************************
*
* CALLED FROM
*
*	noise2	biterror
*
* CALLS
*
*
***************************************************************************
*	
* REFERENCE
*
*	Knuth, The Art of Programming, Volume 2, p. 27.
*
**************************************************************************/
# define MIDTAP 2
# define MAXTAP 5
random2()
{
  static int j = MIDTAP-1, k = MAXTAP-1;
  static int y[MAXTAP] = {-21161,-8478,30892,-10216,16950};
  int temp;

  /* * simulate 2's complement 16-bit addition				 */

  temp = (y[k] + y[j]) & 65535;
  temp = (temp > 32767 ? temp - 65536 : temp);
  y[k] = temp;
  k = (--k < 0 ? MAXTAP-1 : k);
  j = (--j < 0 ? MAXTAP-1 : j);
  return(temp);
}	
