/**************************************************************************
*
* ROUTINE
*               puthex (pack an array of bits into a bitstream)
*
* FUNCTION
*               Input an array of bits and number of bits and the
*               program returns a pointer to a bitstream.
*
* SYNOPSIS
*               subroutine puthex(nb, bits, line)
*
*   formal 
*
*                       data    I/O
*       name            type    type    function
*       -------------------------------------------------------------------
*       nb		int	i	number of bits
*       bits		int	i	bit array
*       line		char	o	packed character bitstream
*
***************************************************************************
*
* DESCRIPTION
*
*       This program packs an array of bits into a string of hex
*       characters where each character represents 4 bits.  The 
*	character stream is nb/4 characters long.
*
***************************************************************************
*
* CALLED BY
*
*       celp
*
* CALLS
*
*
*
**************************************************************************/
#include <stdio.h>
puthex(nb, bits, line)
int nb, bits[];
char line[];
{
  int i, j;
  
  for (j = 0; j < nb;)
  {
    i = 0;
    do
    {
      i |= (bits[j]&1)<<(3 - j%4);
    } while (++j%4 != 0);
    sprintf(&line[j/4-1],"%X",i);
  }
}  

/**************************************************************************
*
* ROUTINE
*               gethex (unpack a bitstream into an array of bits)
*
* FUNCTION
*               Input a pointer to a bitstream and number of bits,
*               program returns an array of bits.
*
* SYNOPSIS
*               subroutine gethex(nb, bits, line)
*
*   formal 
*
*                       data    I/O
*       name            type    type    function
*       -------------------------------------------------------------------
*       nb		int	i	number of bits
*       bits		int	o	bit array
*       line		char	i	packed character bitstream
*
***************************************************************************
*
* DESCRIPTION
*
*       This routine takes a string of hex characters and unpacks
*       them into an array of bits, 4 bits for each character.
*
***************************************************************************
*
* CALLED BY
*
*       celp
*
* CALLS
*
*
*
**************************************************************************/
gethex(nb, bits, line)
int nb, bits[];
char line[];
{
  int i, j;
  
  for (j = 0; j < nb;)
  {
    sscanf(&line[j/4],"%1X",&i);
    do
    {
      bits[j] = ((int) (i & (1 << (3 - j%4))) != 0);
    } while (++j%4 != 0);
  }
}  
