C==========================================================================
C
C ROUTINE
C               zerofilt
C
C FUNCTION
C               Direct form all-zero filter
C
C SYNOPSIS
C               subroutine zerofilt(b, n, z, xy, len)
C
C   formal 
C
C                       data    I/O
C       name            type    type    function
C       -------------------------------------------------------------------
C	b		real	i	N+1 filter coefficients
C	n		int	i	Filter order 
C	z		real	i	N+1 filter delay elements 
C					(maintained by the user)
C	xy		real	i/o	Input/Output data array 
C	len		int	i	Number of samples to filter
C
C==========================================================================
C       
C DESCRIPTION
C
C	Nonrecursive all-zero in-place time-domain filter.
C	The filter is implemented in a direct form realisation.
C
C               N       -i
C       H(z) = SUM b(i)z
C              i=0
C
C       x(t) ->---(z0)----- b0 >------+-----> y(t)
C                  |                  |
C                  z1------ b1 >------+
C                  |                  |
C                  z2------ b2 >------+
C                  |                  |
C                  :                  :
C                  |                  |
C                  zN------ bN >------+
C
C==========================================================================
C
C CALLED BY
C
C	celp	confg	postfilt
C
C CALLS
C
C
C==========================================================================
C
C REFERENCES
C
C	Oppenheim & Schafer, Digital Signal Processing, PH, 1975, p. 149.
C
C**************************************************************************
C*-
	subroutine zerofilt(b, n, z, xy, len)
	implicit undefined(a-z)
	integer n, len
	real b(0:n), z(0:n), xy(len)
	integer t, j
	real ar
C
	do 69 t = 1, len
	   z(0) = xy(t)
	   ar   = 0.0
	   do 10 j = n, 1, -1
	      ar   = ar + z(j)*b(j)
	      z(j) = z(j-1)
10	   continue
	   xy(t) = ar + z(0)*b(0)
69	continue
	return
	end
