c==========================================================================
c
c ROUTINE
c		unpack (unpack from binary to decimal)
c
c FUNCTION
c		Input binary array and number of binary bits, 
c		program returns unpacked decimal value.
c
c SYNOPSIS
c		subroutine unpack(array, bits, value, pointer)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c	array		I*2	I	array to which one bit is assigned
c					for binary representation
c	bits		I	I	number of bits to convert 
c					(ie. 01001 for 5 bits, 1st 0 incl.)
c	streambits	I	I	number of bits in 1 CELP frame
c	value		I	O	decimal value to convert to
c	pointer		I	I/O	points to appropriate element in
c					array
c
c==========================================================================
c
c DESCRIPTION
c
c	This program unpacks binary values packed by pack.f
c	into decimal values.
c
c**************************************************************************
c
	subroutine unpack(array, bits, streambits, value, pointer)
c
	implicit undefined(a-z)
	integer i, bits, value, pointer, dummy, streambits
	integer*2 array(streambits)
c
	value=0
	do 10 i=1,bits
	  dummy=(array(pointer+i))*(2**(i-1))
	  value=dummy+value
10	continue
	pointer=pointer+bits
	return
	end

	    
