c==========================================================================
c
c ROUTINE
c               smoothtau
c
c FUNCTION
c                
c               smooth tau values when two errors detected in Hamming block
c
c SYNOPSIS
c               smoothtau(tau,twoerror,syndavg,tau3,subframe)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c       tau		real	i/o	input tau
c	twoerror	log	i	two error flag
c	syndavg		real	i	error rate estimation parameter
c	tau3		int	i	third tau value
c	subframe	int	i	subframe number
c
c==========================================================================
c
c DESCRIPTION
c
c	Smoothing routine to smooth tau (pitch lag) when errors are detected:
c
c	If the variance of past tau values is within the range VARLIMIT 
c	(indicating voiced speech) the validity of the current tau value
c	is tested.  If the current value of tau is within the range TAULIMIT,
c	TAU is passed.  If TAU is not within the range TAULIMIT, TAU is reset
c	to the average value of taus.
c 
c	The array OLDTAU contains past values of tau.  The array VECTOR
c	is constructed from the array OLDTAU and TAU3 for subframes 1
c	and 2 (TAU3 is a future absolute tau value).  For subframes 3
c	and 4 there are no valid future values (since delta taus in the 
c	future are not valid), therefore the array VECTOR is constructed 
c	entirely from the array OLDTAU.  Decisions concering smoothing of 
c	a particular tau are made on the variance of the array VECTOR and 
c	the tau in question (TAU).
c
c	If the value of tau is smoothed in subframe 3, smoothing is disabled
c	for subframe 4 of the same frame since the tau value in subframe 4
c	is a delta based on subframe 3.
c
c	Note:  The smoothing parameters should be capable of adapting
c	to various bit error rate estimates. For example, different
c	values of SYNDAVG should select different levels of TAULIMIT and
c	VARLIMIT.
c
c**************************************************************************
c
	subroutine smoothtau(tau,twoerror,syndavg,tau3,subframe)
	implicit undefined(a-z)
c
	real tau,syndavg,tau3
	logical twoerror,enable
	include 'ccsub.com'
convex	#include "ccsub.com"
	integer tauhistory,taulimit,varlimit,subframe,i
	parameter (tauhistory=4)
	real avg,var,vector(4),oldtau(tauhistory)
c
	save oldtau,enable
c
	parameter (taulimit=15)
	parameter (varlimit=15)
c
	if (subframe .ne. 4) enable = .true.
	if ((twoerror .or. syndavg.gt.0.04) .and. enable) then
	   if (subframe .eq. 1) then
	      vector(1)=oldtau(1)
	      vector(2)=oldtau(2)
	      vector(3)=oldtau(3)
	      vector(4)=tau3
	   else if (subframe .eq. 2) then
	      vector(1)=oldtau(1)
	      vector(2)=oldtau(2)
	      vector(3)=oldtau(3)
	      vector(4)=tau3
	   else if (subframe .eq. 3) then
	      vector(1)=oldtau(1)
	      vector(2)=oldtau(2)
	      vector(3)=oldtau(3)
	      vector(4)=oldtau(4)
	   else if (subframe .eq. 4) then
	      vector(1)=oldtau(1)
	      vector(2)=oldtau(2)
	      vector(3)=oldtau(3)
	      vector(4)=oldtau(4)
	   else
	      print *,' smoothtau:  Error in subframe number'
	   end if
	   call variance(vector,4,var,avg)
	   if (var.lt.varlimit .and. 
     &           (tau.ge.avg+taulimit .or. tau.le.avg-taulimit)) then
	      tau=nint(avg)
	      print *,' smoothtau:  tau value reset to avg',
     &                ' at frame', frame,' subframe', subframe
	      if (subframe .eq. 3) then
		 enable = .false.
		 print *,' smoothtau:  tau smoothing disabled for subframe 4'
	      end if
	   end if
	end if
	do 30 i=tauhistory-1,1,-1
	   oldtau(i+1)=oldtau(i)
30	continue
	oldtau(1)=tau
	return   
	end
