c==========================================================================
c
c ROUTINE
c               smoothcbgain
c
c FUNCTION
c                
c               smooth cbgain values when two errors detected in 
c		Hamming block
c
c SYNOPSIS
c               smoothcbgain(cbgain,twoerror,syndavg,gains,subframe)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c       cbgain		real	i/o	input cbgain
c	twoerror	log	i	two error flag
c	syndavg		real	i	error rate estimation parameter
c	gains		real	i	vector of gains to calculate variance
c	subframe	int	i	subframe number
c
c==========================================================================
c
c DESCRIPTION
c
c	Smoothing routine to smooth cbgain when errors are detected:
c
c	If the variance of past cbgain values is within the range VARLIMIT, 
c	the validity of the current cbgain value is tested.  If the current 
c	value of cbgain is within the range CBGAINLIMIT, CBGAIN is passed.
c	If CBGAIN is not within the range CBGAINLIMIT it is reset to the 
c	average value of the surrounding cbgain values.
c
c	The array OLDCBGAIN contains past values of cbgain.  The array
c	GAINS contains current and future values of cbgain.  The array
c	VECTOR is constructed from the arrays OLDCBGAIN and GAINS
c	depending on the current subframe.  CBGAIN is smoothed based on
c	the statistics of VECTOR, which contains the nearest four 
c	surrounding cbgain values, both past and future values, except
c	where future values are not available (subframes 3 and 4).
c
c	Note:  The smoothing parameters should be capable of adapting
c	to various bit error rate estimates. For example, different
c	values of SYNDAVG should select different levels of CBGAINLIMIT,
c	VARLIMIT, and SYNDLIMIT.
c
c**************************************************************************
c
	subroutine smoothcbgain(cbgain,twoerror,syndavg,gains,subframe)
	implicit undefined(a-z)
c
	real cbgain,syndavg,gains(4)
	logical twoerror,enable
	include 'ccsub.com'
convex	#include "ccsub.com"
	integer cbgainhistory,subframe
	parameter (cbgainhistory=4)
	real oldcbgain(cbgainhistory),avg,var,abscbgain,vector(4)
	integer i,sign
	real varlimit,cbgainlimit,sgainlimit,svarlimit,avglimit,syndlimit
c
	save oldcbgain,enable
c
	parameter (cbgainlimit=300.)
	parameter (varlimit=30000.)
	parameter (sgainlimit=9.)
	parameter (svarlimit=10.)
	parameter (avglimit=6.)
	parameter (syndlimit=0.04)
c
	abscbgain=abs(cbgain)
	if (subframe .ne. 4) enable = .true.
	if ((twoerror .or. syndavg.gt.syndlimit) .and. enable) then
	   if (subframe .eq. 1) then
	      vector(1)=oldcbgain(1)
	      vector(2)=oldcbgain(2)
	      vector(3)=abs(gains(2))
	      vector(4)=abs(gains(3))
	   else if (subframe .eq. 2) then
	      vector(1)=oldcbgain(1)
	      vector(2)=oldcbgain(2)
	      vector(3)=abs(gains(3))
	      vector(4)=abs(gains(4))
	   else if (subframe .eq. 3) then
	      vector(1)=oldcbgain(1)
	      vector(2)=oldcbgain(2)
	      vector(3)=oldcbgain(3)
	      vector(4)=abs(gains(4))
	   else if (subframe .eq. 4) then
	      vector(1)=oldcbgain(1)
	      vector(2)=oldcbgain(2)
	      vector(3)=oldcbgain(3)
	      vector(4)=oldcbgain(4)
	   else
	      print *,' smoothcbgain:  Error in subframe number'
	   end if
	   call variance(vector,4,var,avg)
	   sign=nint(cbgain/abs(cbgain))
	   if (var.lt.varlimit .and. (abscbgain.gt.avg+cbgainlimit .or.
     &         abscbgain.lt.avg-cbgainlimit)) then
	      abscbgain=avg
	      print *,' smoothcbgain:  cbgain value reset to avg cbgains',
     &                ' at frame', frame,' subframe', subframe
	      cbgain=sign*abscbgain
	      if (subframe .eq. 3) then
		 enable = .false.
		 print *,' smoothcbgain:  smoothing disabled for subframe 4'
	      end if
	   end if
	   if ((var.lt.svarlimit) .and. (abscbgain.gt.sgainlimit) .and. 
     &         (avg.lt.avglimit) .and. enable) then 
	      abscbgain=avg
	      cbgain=sign*abscbgain
	      print *,' smoothcbgain:  cbgain value reset to avg (silence?)',
     &	      ' at frame', frame,' subframe', subframe
	      if (subframe .eq. 3) then
		 enable = .false.
		 print *,' smoothcbgain:  smoothing disabled for subframe 4'
	      end if
	   end if
	end if
	do 30 i=cbgainhistory-1,1,-1
	   oldcbgain(i+1)=oldcbgain(i)
30	continue
	oldcbgain(1)=abscbgain
	return
	end
