C===========================================================================
C
C    SUNGRAPH OPEN FILE AND DEFINE VARIABLE (doesn't apply to PC release)
C
C===========================================================================
C
C	*** SUNGRAPH FILES AND VARIABLES
C
C	ifile.spd		   input file
C
C	ifile_ofile.sg_data	   input and output file 
C				   'ifile' 'ifile_hp' 
C				   'ofile_npf' 'ofile_pf' 'ofile_hpf'
C
C	channel.sg_data		   4800 bps bit stream
C				   'stream'
C
C	stream_error.sg_data	   4800 bps bit stream with errors
C				   'stream' 'stream_error' 'stream_error_s' 
C				   'error'
C
C	lsp1.sg_data		   line spectral pairs file on a frame basis
C				   comparing unquantized and quantized
C	 			   'lsp 1' 'lsp 2' ... 'lsp10' ...
C				   'qlsp 1' ...  'qlsp10'
C				   'qslsp 1' ... 'qslsp10'
C
C	lsp2.sg_data		   line spectral pairs file on a subframe basis
C				   comparing analysis and synthesis
C				   'lsp_analy 1' 'lsp_analy 2' ...
C				   'lsp_synth 1' 'lsp_synth 2' ...
C
C	pitch.sg_data		   pitch variables 
C				   'match' 'tau' tau_synth' 'ir'
C				   'gain' 'qgain' 'qgain_synth'
C
C	constrain.sg_data	   constrained excitation data
C				   'gain', 'ccor', 'dbcon'
C
C	codebook.sg_data	   code book variables
C				   'match' 'index' 'index_synth' 'exc' 'ir'
C				   'gain' 'qgain' 'qgain_synth'
C
C	error.sg_data		   error signals
C				   'fndpp_e0' 'fndpp_v0' 'fndex_e0'
C
C	rc.sg_data		   reflection coeficients
C				   'rc 1' 'rc2' ... 'rc10' ...
C
C**************************************************************************
c
c	*** open files and define variables in sungraph format
c
c
c			* disable disk_io auto error reporting
	call disk_io_erh(0)
c
c			* open input speech file
	temp_fname=ifile
	I=index(temp_fname,' ')
	temp_fname(I:I)=char(0)
	input_fid=open_var_channel(temp_fname,'speech_data')
	if (input_fid .lt. 0) call read_error(input_fid,' open input_fid')
c
c			* open input_output speech file (4 variables)
	ifile_ofile_fid=open_file('ifile_ofile' // char(0),1)
	if (ifile_ofile_fid .lt. 0) call write_error(ifile_ofile_fid,
     &  'open ifile_ofile_fid')
c
c			* define input_output speech variables
	ifile_vid=def_variable(ifile_ofile_fid,'ifile' // char(0),r4,ll,0)
	if (ifile_vid .lt. 0) call write_error(ifile_vid,'define ifile_vid')
	ifile_hp_vid=def_variable(ifile_ofile_fid,'ifile_hp' // 
     &  char(0),r4,ll,0.0)
	if (ifile_hp_vid .lt. 0) call write_error(ifile_hp_vid,
     &  'define ifile_hp_vid')
	ofile_npf_vid=def_variable(ifile_ofile_fid,'ofile_npf' // 
     &  char(0),i2,ll,0)
	if (ofile_npf_vid .lt. 0) call write_error(ofile_npf_vid,
     &  'define ofile_npf_vid')
	ofile_pf_vid=def_variable(ifile_ofile_fid,'ofile_pf' // 
     &  char(0),i2,ll,0)
	if (ofile_pf_vid .lt. 0) call write_error(ofile_pf_vid,
     &  'define ofile_pf_vid')
	ofile_hpf_vid=def_variable(ifile_ofile_fid,'ofile_hpf' // 
     &  char(0),i2,ll,0)
	if (ofile_hpf_vid .lt. 0) call write_error(ofile_hpf_vid,
     &  'define ofile_hpf_vid')
c
c			* open channel file
	channel_fid=open_file('channel' // char(0),1)
	if (channel_fid .lt. 0) call write_error(channel_fid,
     &  'open channel_fid')
c
c			* define channel variable
	channel_vid=def_variable(channel_fid,'stream' //char(0),
     &  1,streambits,0)
	if (channel_vid .lt. 0) call write_error(channel_vid,
     &  'define channel_vid')
c
c			* open stream_error file
	stream_error_fid=open_file('stream_error' // char(0),1)
	if (stream_error_fid .lt. 0) call write_error(stream_error_fid,
     &  'open stream_error_fid')
c
c			* define stream_error variables
	stream_vid=def_variable(stream_error_fid,'stream' //char(0),
     &  1,streambits,0)
	if (stream_vid .lt. 0) call write_error(stream_vid,
     &  'define stream_vid')
	stream_error_vid=def_variable(stream_error_fid,
     &  'stream_error'//char(0),1,streambits,0)
	if (stream_error_vid .lt. 0) call write_error(stream_error_vid,
     &  'define stream_error_vid')
	stream_error_s_vid=def_variable(stream_error_fid,
     &  'stream_error_s'//char(0),1,streambits,0)
	if (stream_error_s_vid .lt. 0) call write_error(stream_error_s_vid,
     &  'define stream_error_s_vid')
	bit_error_vid=def_variable(stream_error_fid,
     &  'bit_error' //char(0),1,streambits,0)
	if (bit_error_vid .lt. 0) call write_error(bit_error_vid,
     &  'define bit_error_vid')
c
c			* open lsp1 file (number of variables = order)
	lsp1_fid=open_file('lsp1' // char(0), 1)
	if (lsp1_fid .lt. 0) call write_error(lsp1_fid,'open lsp1_fid')
c
c			* define lsp and qlsp variables 
	do 90 i=1,no
	   write(str,91) i,0
91	   format('lsp',i2,a)
	   lsp_vid(i)=def_variable(lsp1_fid, str, r4, 1, 0.0)
	   if (lsp_vid(i) .lt. 0) call write_error(lsp_vid(i),
     &     'define lsp_vid')
	   write(str,92) i,0
92	   format('qlsp',i2,a)
	   qlsp_vid(i)=def_variable(lsp1_fid, str, r4, 1, 0.0)
	   if (qlsp_vid(i) .lt. 0) call write_error(qlsp_vid(i),
     &     'define qlsp_vid')
90	continue
c
c			* open lsp2 file (number of variables = order)
	lsp2_fid=open_file('lsp2' // char(0), 1)
	if (lsp2_fid .lt. 0) call write_error(lsp2_fid,'open lsp2_fid')
c
c			* define qlsp variables
	do 93 i=1,no
	   write(str,94) i,0
94	   format('lsp_analy',i2,a)
	   lsp_analy_vid(i)=def_variable(lsp2_fid, str, r4, nn, 0.0)
	   if (lsp_analy_vid(i) .lt. 0) call write_error(lsp_analy_vid(i),
     &     'define lsp_analy_vid')
	   write(str,95) i,0
95	   format('lsp_synth',i2,a)
	   lsp_synth_vid(i)=def_variable(lsp2_fid, str, r4, nn, 0.0)
	   if (lsp_synth_vid(i) .lt. 0) call write_error(lsp_synth_vid(i),
     &     'define lsp_synth_vid')
93	   continue
c
c			*open pitch file
	pitch_fid=open_file('pitch' // char(0),1)
	if (pitch_fid .lt. 0) call write_error(pitch_fid,
     &  'open pitch_fid')
c
c			*define pitch variables
	pitch_match_vid=def_variable(pitch_fid,'match' // char(0),r4,
     &  nn*plevel1,0.0)
	if (pitch_match_vid .lt. 0) call write_error(pitch_match_vid,
     &  'define pitch_match_vid')
	pitch_tau_vid=def_variable(pitch_fid,'tau' // char(0),r4,nn,0)
	if (pitch_tau_vid .lt. 0) call write_error(pitch_tau_vid,
     &  'define pitch_tau_vid')
	pitch_tau_synth_vid=def_variable(pitch_fid,'tau_synth' // char(0),
     &  r4,nn,0)
	if (pitch_tau_synth_vid .lt. 0) call write_error
     &  (pitch_tau_synth_vid,'define pitch_tau_synth_vid')
	pitch_gain_vid=def_variable(pitch_fid,'gain' // char(0),r4,nn,0.0)
	if (pitch_gain_vid .lt. 0) call write_error(pitch_gain_vid,
     &  'define pitch_gain_vid')
	pitch_qgain_vid=def_variable(pitch_fid,'qgain' // char(0),r4,nn,0.0)
	if (pitch_qgain_vid .lt. 0) call write_error(pitch_qgain_vid,
     &  'define pitch_qgain_vid')
	pitch_qgain_synth_vid=def_variable(pitch_fid,
     &  'qgain_synth' // char(0),r4,nn,0.0)
	if (pitch_qgain_synth_vid .lt. 0) 
     &  call write_error(pitch_qgain_synth_vid,
     &  'define pitch_qgain_synth_vid')
	pitch_ir_vid=def_variable(pitch_fid,'ir' // char(0),r4,ll,0.0)
	if (pitch_ir_vid .lt. 0) call write_error(pitch_ir_vid,
     &  'define pitch_ir_vid')
c
c			*open constrain file
	constrain_fid=open_file('constrain' // char(0),1)
	if (constrain_fid .lt. 0) call write_error(constrain_fid,
     &              'open constrain_fid')
c
c			*define constrain variables
	gain_vid=def_variable(constrain_fid,'gain' // char(0),r4,nn,0.0)
	if (gain_vid .lt. 0) call write_error(gain_vid,
     &  'define gain_vid')
   	ccor_vid=def_variable(constrain_fid,'ccor' // char(0),r4,nn,0)
	if (ccor_vid .lt. 0) call write_error(ccor_vid,
     &  'define ccor_vid')
   	dbcon_vid=def_variable(constrain_fid,'dbcon' // char(0),r4,nn,0)
	if (ccor_vid .lt. 0) call write_error(ccor_vid,
     &  'define ccor_vid')
c
c			*open code book file
	cb_fid=open_file('codebook' // char(0),1)
	if (cb_fid .lt. 0) call write_error(cb_fid,'open cb_fid')
c
c			*define code book variables
	cb_match_vid=def_variable(cb_fid,'match' // char(0),r4,nn*ncsize,0.0)
	if (cb_match_vid .lt. 0) call write_error(cb_match_vid,
     &  'define cb_match_vid')
   	cb_index_vid=def_variable(cb_fid,'index' // char(0),2,nn,0)
	if (cb_index_vid .lt. 0) call write_error(cb_index_vid,
     &  'define cb_index_vid')
   	cb_index_synth_vid=def_variable(cb_fid,
     &  'index_synth' // char(0),2,nn,0)
	if (cb_index_synth_vid .lt. 0) call write_error(cb_index_synth_vid,
     &  'define cb_index_synth_vid')
   	cb_gain_vid=def_variable(cb_fid,'gain' // char(0),r4,nn,0.0)
	if (cb_gain_vid .lt. 0) call write_error(cb_gain_vid,
     &  'define cb_gain_vid')
   	cb_qgain_vid=def_variable(cb_fid,'qgain' // char(0),r4,nn,0.0)
	if (cb_qgain_vid .lt. 0) call write_error(cb_qgain_vid,
     &  'define cb_qgain_vid')
   	cb_qgain_synth_vid=def_variable(cb_fid,'qgain_synth' // char(0),
     &  r4,nn,0.0)
	if (cb_qgain_synth_vid .lt. 0) call write_error(cb_qgain_synth_vid,
     &  'define cb_qgain_synth_vid')
    	cb_exc_vid=def_variable(cb_fid,'exc' // char(0),r4,ll,0.0)
	if (cb_exc_vid .lt. 0) call write_error (cb_exc_vid,
     &  'define cb_exc_vid')
	cb_ir_vid=def_variable(cb_fid,'ir' // char(0),r4,ll,0.0)
	if (cb_ir_vid .lt. 0) call write_error(cb_ir_vid,'define cb_ir_vid')
c
c			*open error file
	error_fid=open_file('error' // char(0),1)
	if (error_fid .lt. 0) call write_error(error_fid,
     &  'open error_fid')
c
c			*define error variables
	fndpp_v0_vid=def_variable(error_fid,'fndpp_v0' // char(0),
     &  r4,ll,0.0)
	if (fndpp_v0_vid .lt. 0) call write_error(fndpp_v0_vid,
     &  'define fndpp_v0_vid')
	fndpp_e0_vid=def_variable(error_fid,'fndpp_e0' // char(0),
     &  r4,ll,0.0)
	if (fndpp_e0_vid .lt. 0) call write_error(fndpp_e0_vid,
     &  'define fndpp_e0_vid')
	fndex_e0_vid=def_variable(error_fid,'fndex_e0' // char(0),r4,
     &  ll,0.0)
	if (fndex_e0_vid .lt. 0) call write_error(fndex_e0_vid,
     &  'define fndex_e0_vid')
c
c			*open reflection coefficient file
	rc_fid=open_file('rc' // char(0),1)
	if (rc_fid .lt. 0) call write_error(rc_fid, 'open rc_fid')
c
c			*define rc variables
	do 351 i=1,no
	   write(str,352) i,0
352	   format('rc',i2,a)
	   rc_vid(i)=def_variable(rc_fid, str, r4, 1, 0.0)
	   if (rc_vid(i) .lt. 0) call write_error(rc_vid(i), 
     &     'define rc_vid')
351	continue
	predgain_vid=def_variable(rc_fid,'prediction_gain' // char(0),
     &  r4,1,0.0)
	if (predgain_vid .lt. 0) call write_error(predgain_vid,
     &  'define predgain_vid')
	preddiff_vid=def_variable(rc_fid,'prediction_delta' // char(0),
     &  r4,1,0.0)
	if (preddiff_vid .lt. 0) call write_error(preddiff_vid,
     &  'define preddiff_vid')
	predavg_vid=def_variable(rc_fid,'prediction_avg' // char(0),
     &  r4,1,0.0)
	if (predavg_vid .lt. 0) call write_error(predavg_vid,
     &  'define predavg_vid')
	mindiff_vid=def_variable(rc_fid,'minlspdelta' // char(0),
     &  r4,1,0.0)
	if (mindiff_vid .lt. 0) call write_error(mindiff_vid,
     &  'define mindiff_vid')
c
