C==========================================================================
C
C ROUTINE
C		RANDOM (LPC-10e Version 49)
C
C FUNCTION
C
C		Pseudo random number generator.
C
C SYNOPSIS
C		function random()
C
C   formal 
C                       data    I/O
C       name            type    type    function
C       -------------------------------------------------------------------
C	random		i	fun	uniformly distributed
C					over -32768 to 32767
c==========================================================================
c	
c DESCRIPTION
c
c	See reference.
c
c==========================================================================
c	
c REFERENCE
c
c	Knuth, The Art of Programming, Volume 2, p. 27.
c
c==========================================================================
c
	function random ()
	implicit undefined(a-z)
	integer random, j, k, midtap, maxtap
	parameter (midtap=2, maxtap=5)
	integer y(maxtap), temp
	save j, k, y
	data y /-21161, -8478, 30892,-10216, 16950/
	data j/midtap/, k/maxtap/

* simulate 2's complement 16-bit addition

	temp = and (y(k) + y(j), 65535)
cAlli	temp = iand (y(k) + y(j), 65535)
	if (temp .gt. 32767) temp = temp - 65536
	y(k) = temp
	random = temp
	k = k - 1
	if (k .le. 0) k = maxtap
	j = j - 1
	if (j .le. 0) j = maxtap

	return
	end

