c==========================================================================
c
c ROUTINE
c		pitchencode
c
c FUNCTION
c		 
c		encode and quantize pitch gain (bb(3)) for various
c		quantizer types.
c
c SYNOPSIS
c		subroutine pitchencode(input, bits, type, index)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c	input		i	i	pitch gain input (true value)
c	bits		i	i	# bits for encode
c	type		c	i	type of quantization
c	index		r	o	encoded pitch gain index
c	pitchencode	r	f	encoded pitch gain
c
c==========================================================================
c
c DESCRIPTION
c
c	This funtion uses output level data obtained by Max's minimum
c	distortion quantization priciples and quantizes to the nearest
c	level (L1 norm).  (Using level data only was found superior to
c	using both of Max's level and boundry data.)
c
c==========================================================================
c	
c REFERENCES
c
c	Quantizing for Minimum Distorion
c	J. Max 
c	IRE Trans. Inform. Theory, vol. IT-6, pp.7-12, Mar. 1960
c
C==========================================================================
C 
C INPUT FILES
C	pgain.tbl		pitch gain gain coding
C
c**************************************************************************
c
c
	real function pitchencode(input, bits, type, index)
	implicit undefined(a-z)
c
	real input
	integer bits, index
	character*10 type
	integer i
	real quantize
	real pitch2max5(32)
c
	include './pgain.tbl'
convex	#include "./pgain.tbl"
c
c	*** Choose appropriate pitch
c
	if (bits .eq. 5) then
	   if (type .eq. 'max2') then
	      pitchencode=quantize(input,pitch2max5,2**bits,index)
	   else
	      print *,' pitchencode:  unquantized pgain'
	   end if
	else
	   print *,' pitchencode:  unquantized pgain'
	end if
	return
	end

