c==========================================================================
c
c ROUTINE
c               prefilt
c
c FUNCTION
c                
c               pitch prefilter
c
c SYNOPSIS
c               subroutine prefilt(s, l, dpp)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c       s		real	i/o	speech input/postfiltered output
c	l		int	i	subframe size
c	dpp		real	i/o	filter memory
c
c==========================================================================
c
c DESCRIPTION
c	Note:  The pitch prefilter using a weighting factor 0.4 does not
c	alter the output speech quality (as determinted in blind listening 
c	tests) and therefore we do not use the prefilter.  However we are 
c	providing this code for research purposes.  Perhaps with other
c	enhancements or other conditions other than what we have tested,
c	the prefilter will enhance speech quality sufficiently to warrant
c	its extra computational burden.
c
c==========================================================================
c
c REFERENCES
c	Gerson, Ira A. and Mark A. Jasuik, "Vector Sum Excited Linear
c	Prediction (VSELP) Speech Coding at 8 kbps", Proceedings of ICASSP
c	'90, p. 461.
c
c==========================================================================
c

	subroutine prefilt(s, l, dpp)
	implicit undefined(a-z)
	include 'ccsub.com'
convex	#include "ccsub.com"
	integer l, n
	real s(l), dpp(maxpa), tc, scale2, powerin, powerout
	parameter (tc = 0.01)
c
c			*estimate input power
	powerin = 0.0
	do 10 n = 1, l
ccc	   powerin = (1.-tc)*powerin + tc*s(n)**2
	   powerin = powerin + s(n)**2
10	continue
	bb(3) = prewt * bb(3)
	call pitchvq(s, l, dpp, idb, bb,'short')
c
c			*estimate output power
	powerout = 0.0
	do 20 n = 1, l
ccc	   powerout = (1.-tc)*powerout + tc*s(n)**2
	   powerout = powerout + s(n)**2
20	continue
c
c			*block wise automatic gain control
	if (powerout .gt. 0.0) then
	   scale2 = sqrt(powerin/powerout)
	   do 30 n = 1, l
	      s(n) = scale2*s(n)
30	   continue
	end if
	return
	end
