C==========================================================================
C
C ROUTINE
C		polefilt
C
C FUNCTION
C		Direct form all-pole filter
C
C SYNOPSIS
C		subroutine polefilt(a, n, z, xy, len)
C
C   formal 
C
C                       data    I/O
C       name            type    type    function
C       -------------------------------------------------------------------
C	a		real	i	N+1 filter coefficients
C	n		int	i	Filter order 
C	z		real	i	N+1 filter delay elements
C					(maintained by the user)
C					(z(0) is a dummy delay)
C	xy		real	i/o	Input/Output data array 
C	len		int	i	Number of samples to filter
C
C==========================================================================
C       
C DESCRIPTION
C
C	Recursive all-pole in-place time-domain filter.
C	The transfer function 1/A(z) is implemented
C	in a direct form realisation.
C 
C                   N       -i
C       H(z) = 1 / SUM a(i)z         with a(0) = +1.0
C                  i=0
C
C	NOTE:  a(0) is not used for the actual computing,
C	as can easily be seen in the following flow graph.
C
C       x(t) ->---+------->--------(z0)-----> y(t)
C                 |                  |
C                 +-------< -a1 ----z1
C                 |                  |
C                 +-------< -a2 ----z2
C                 |                  |
C                 :                  :
C                 |                  |
C                 +-------< -aN ----zN
C
C==========================================================================
C
C CALLED BY
C
C	celp	confg	impulse	postfilt
C
C CALLS
C
C
C
C==========================================================================
C
C REFERENCES
C
C	Oppenheim & Schafer, Digital Signal Processing, PH, 1975, p. 149.
C
C**************************************************************************
C*-
	subroutine polefilt(a, n, z, xy, len)
	implicit undefined(a-z)
	integer n, len
	real a(0:n), z(0:n), xy(len)
	integer t, j
c
	if (a(0) .ne. 1.0) stop 'polefilt:  bad coefficients'
c
	do 69 t = 1, len
	   z(0) = xy(t)
	   do 10 j = n, 1, -1
	      z(0) = z(0) - a(j)*z(j)
	      z(j) = z(j-1)
10	   continue
	   xy(t) = z(0)
69	continue
	return
	end
