C==========================================================================
C
C ROUTINE
C               pitchvq
C
C FUNCTION
C               Pitch VQ (n-taps, where n = 0, ..., 3)
C		"self-excited" or "vq" or "adaptive code book"
C
C SYNOPSIS
C               subroutine pitchvq(rar, idim, buf, idimb, b, type)
C
C   formal 
C
C                       data    I/O
C       name            type    type    function
C       -------------------------------------------------------------------
C	rar		real	i/o	Data segement/Filtered data segment
C	idim		int	i	Dimension of data segement RAR
C	buf		real	i	Data buffer, dim IDIMB
C	idimb		int	i	Dimension of data buffer is 
C						max(M) + IDIM+1
C	b(1)		real	i	Pitch delay (M)
C	b(2-4)		real	i	pitch predictor coefficients. 
C					BETA1=B(2),BETA2=B(3), BETA3=B(4)
C					For a 1-tap predictor B(2)=B(4)=0.0
C	type		char	i	Type 'long' calls ldelay.f, the
C					delay routine using long 
C					interpolation windows.  Type 'short'
C					calls delay.f, the short delay
C					routine.
C==========================================================================
C       
C USAGE
C
C    Adaptive code book (pitch) synthesis routine:
C
C    1) For lags < frame size:  gain-shape adaptive code book VQ
C
C    2) For lags => frame size this is equivalent to a pitch synthesis "filter"
C
C                              -[b(1)-1]        -b(1)        -[b(1)+1]
C       H(z) =  1 /  1 + b(2) z         + b(3) z     + b(4) z
C
C       NOTE: largest delay must not exceed the value IDIMB-IDIM
C
c==========================================================================
c	
c REFERENCES
c
c	Singhal & Atal, Improving Performance of Multi-Pulse LPC Coders at
c	Low Bit Rates, ICASSP, 1984.
c
c	Rose & Barnwell.  The Self Excited Vocoder-An Alternate Approach
c	to Toll Quality at 4800 bps, ICASSP, 1986, pp. 453-456.
c
c	Kleijn, Krasinski and Ketchum, Improved Speech Quality and
c	Efficient Vector Quantization in SELP, ICASSP, 1988.
c
C**************************************************************************
C*-
	subroutine pitchvq(rar, idim, buf, idimb, b, type)
	implicit undefined(a-z)
	integer idim, idimb
	character*(*) type
	real rar(idim), buf(idimb), b(4), frac
	include 'ccsub.h'
convex	#include "ccsub.h"
	integer k, m, i, start
	real buf2(maxlp)
C
	k = idimb-idim
	start = k + 1
	m = int(b(1))
	frac = b(1)-m
c
c	update memory
c
	do 10 i = 1, k
	   buf(i) = buf(i+idim)
10	continue
c
c	update memory with selected pitch memory
c	from selected delay (m)
c
	if (abs(frac) .lt. 1.e-4) then
	   do 20 i = 1, idim
	      buf(i+k) = buf(i+k-m)
20	   continue
	end if
c
c	fractional update if fractional part isn't "zero"
c
	if (abs(frac) .gt. 1.e-4) then
	   if (type.eq.'long') then
	      call ldelay(buf, idimb, start, idim, frac, m, buf2)
	   else
	      call delay(buf, idimb, start, idim, frac, m, buf2)
	   end if
	   do 30 i = 1, idim
	      buf(i+k) = buf2(i)
30	   continue
	end if
c
c	return "rar" with scaled memory added
c	to stochastic contribution
c
	do 40 i = 1, idim
	   buf(i+k) = b(3)*buf(i+k) + rar(i)
	   rar(i)   = buf(i+k)
40	continue
	return
	end
