c==========================================================================
c
c NAME
c	pctorc 
c
c FUNCTION
c
c	Convert from lp-polynomial to reflection coefficients.
c
c	BEWARE:  This code does not use memory efficiently.
c
c SYNOPSIS
c
c	subroutine pctorc(a, rc, n)
c
c   formal 
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c       a(n+1)          real    i       Array of n+1 coefficients
c                                       a(0)+a(1)z**(-1) + a(2)Z**(-2) +
c                                       .... + a(n)z**(-n)
c       rc(n)           real    o       reflection coefficients (voiced-> +rc1)
c       n               int     i       Order of polynomial
c     
c==========================================================================
c       
c DESCRIPTION
c
c       This routine uses the Levinson recursion to compute reflection
c       coefficients from the LPC coefficients.  The first LPC
c	coefficient is assumed to be 1, and although it is passed
c	to the routine, it is not used in the calculations.
c       Note:  the dimension of the internal array t limits the value
c	of the maximum order.
c
c	CELP's LPC predictor coefficient convention is:
c              p+1         -(i-1)
c       A(z) = SUM   a   z          where a  = +1.0
c              i=1    i                    1
c
c	The sign convention used defines the first reflection coefficient
c	as the normalized first autocorrelation coefficient, which results
c	in positive values of rc(1) for voiced speech.
c
c**************************************************************************
c-
        subroutine pctorc(lpc, rc, n)
	implicit undefined(a-z)
	include 'ccsub.h'
convex	#include "ccsub.h"
	integer n
        real lpc(0:n), rc(n)
c
	real t(maxno+1), a(0:maxno)
	integer i, j
c
	do 69 i = 0, n
	   a(i) = lpc(i)
69	continue
c
        do 40 i = n, 2, -1
            rc(i) = -a(i)
            do 20 j = 1, i-1
                t(i-j) = (a(i-j)+rc(i)*a(j))/(1.-rc(i)*rc(i))
20          continue
            do 30 j = 1, i-1
                a(j) = t(j)
30          continue
40      continue
        rc(1) = -a(1)
        return
        end
