c==========================================================================
c
c ROUTINE
c		pack (pack tau into binary bit stream)
c
c FUNCTION
c		Input decimal value and number of binary bits, 
c		program returns binary value packed in array.
c
c SYNOPSIS
c		subroutine pack(value,bits,streambits,pdencode,pdbits,array,pointer)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c	value		I	I	decimal value
c	bits		I	I	number of bits to convert to
c					(ie. 01001 for 5 bits, 1st 0 incl.)
c	streambits	I	I	number of bits in CELP frame
c	pdencode	I	I	pitch delay indexing table
c	array		I*2	O	array to which one bit is assigned
c					for binary representation
c	pointer		I	I/O	points to appropriate element in
c					array
c
c==========================================================================
c
c DESCRIPTION
c
c	This program packs a decimal value into a binary value
c	to be decoded by unpacktau.f in CELP synthesizer sections.
c
c**************************************************************************
c
	subroutine packtau(value, bits, streambits, pdencode, array, pointer)
c
	implicit undefined(a-z)
	integer dvalue, i
	integer value, bits, pointer, streambits, pdencode(0:(2**bits)-1)
	integer*2 array(streambits)
	real rvalue, rem
c
c			*change index to permuted index
	value=pdencode(value)
c
c			*insert in bitstream
	rvalue=float(value)
	do 10 i=1,bits
	  rem=amod(rvalue,2.0)
	  if (rem .eq. 0.0) then
	    array(pointer)=0
	  else
	    array(pointer)=1
	  end if
	  dvalue=ifix(rvalue/2.0)
	  rvalue=float(dvalue)
	  pointer=pointer+1
10	continue
	return
	end

	    
