c==========================================================================
c
c ROUTINE
c		matrixgen
c
c FUNCTION
c		 
c		This routine is used to generate the H matrix and 
c	syndrome table necessary for Hamming encode and decode.  This 
c	routine should be called once before calling encodeham and
c	decodeham.
c
c SYNOPSIS
c		subroutine matrixgen(codelength1,codelength2,
c	hmatrix,syndrometable)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c	codelength1	int	i	number of data bits (63)
c	codelength2	int	i	number of information bits (57)
c	hmatrix		int	o	vector to encode an decode by
c	syndrometable 	int	o	table containing error masks
c
c==========================================================================
c
c DESCRIPTION
c
c		This subroutine is part of a set of subroutines which perform
c	a Generalized Hamming Code.  As you know, Hamming codes are perfect
c	codes and can only detect and correct one error.  We added an overall
c 	parity checkbit, which allows us to detect 2 errors.  When 2 errors 
c	are detected, (in subroutine dcodham.f) no correction attempt is
c	made.  This would most likely result in more errors.  Instead, a flag
c	is sent to the calling program notifying it of multiple errors so
c	that smoothing may be attempted.  The Hamming codes presently supported
c	by the routines are (63,57), (31,26), (15,11), and shortened variations
c	thereof.  It could be made even more general by making minor modifications
c	to the dectobin.f subroutine.  This routine at present will calculate 
c	a maximum of 6 bits.
c
c	Hamming routines consist of the following files:
c
c		matrixgen - generates the hmatrix and sydrometable.
c		dectobin  - does a simple decimal to binary conversion.
c		encodeham - generates the code word and overall paritybit.
c		decodeham - recovers infobits, checks for errors, corrects 1
c					error, and sends out flag for smoothing.
c
c	This routine initializes all of the tables necessary to perform
c	the Hamming code (G Matrix, Syndrome Table) .  
c
c==========================================================================
c	
c REFERENCES
c
c	Lin and Costello:  Error Control Coding
c	Berlekamp:  Algebraic Coding Theory
c
c**************************************************************************
c
	subroutine matrixgen(codelength1,codelength2,hmatrix,syndrometable)
	implicit undefined(a-z)
c
	integer codelength1,codelength2
 	integer hmatrix(codelength1),syndrometable(codelength1)
	integer itemplate(6),ptemplate(57),i,temp1
c
c	This is the data necessary to construct the G Matrix and the Syndrome
c	Table.  If a larger code is desired, this table can be easily added to.
c	All other routines, except the syndrome table construction,  
c	are general enough to calculate any size Hamming Code.
c
	data itemplate/1,2,4,8,16,32/
	data ptemplate/3,5,6,7,9,10,11,12,13,14,15,17,18,19,
     + 20,21,22,23,24,25,26,27,28,29,30,31,33,34,35,36,37,38,39,40,41,
     + 42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,
     + 63/
c
c 	Construct the parity portion of the hmatrix
c
	do 30 i=1,codelength2
	   hmatrix(i)=ptemplate(i)
30	continue
c
c	Construct the identity portion of the hmatrix.
c
	do 20 i=1,(codelength1-codelength2)
	   hmatrix((codelength2+i))=itemplate(i)
20	continue
c
c	Construct the syndrometable.  This routine is rather simple because
c	I chose to arrange my G matrix sequentially (Berlekamp method).  
c	I placed the parity bits in front in ascending order then added the 
c	bits left over in ascending order.  Since our code is linear I can get 
c	away with this.  If a larger Hamming code is needed, then a new 
c	exception must be generated for each parity bit.  
c
	temp1=1
	do 10 i=1,codelength1
	   if(i.eq.1)then
	      syndrometable(i)=codelength2+1
	      goto 10
	   end if
	   if(i.eq.2)then
	      syndrometable(i)=codelength2+2
	      goto 10
	   end if
	   if(i.eq.4)then
	      syndrometable(i)=codelength2+3
	      goto 10
	   end if
	   if(i.eq.8)then
	      syndrometable(i)=codelength2+4
	      goto 10
	   end if
	   if(i.eq.16)then
	      syndrometable(i)=codelength2+5
	      goto 10
	   end if
	   if(i.eq.32)then
	      syndrometable(i)=codelength2+6
	      goto 10
	   end if
	   syndrometable(i)=temp1
	   temp1=temp1+1
c
10	continue
c
	return
	end

	    
