C==========================================================================
C
C ROUTINE
C		mexcite
C
C FUNCTION
C		Modify the stochastic code book excitation gain
C
C SYNOPSIS
C               subroutine mexcite1(l)
C               subroutine mexcite2(l)
C               subroutine mexcite3(cgain)
C
C   formal 
C
C                       data    I/O
C       name            type    type    function
C       -------------------------------------------------------------------
C       l		i	i	length of error signal
C	cgain		r	i/o	stochastic code book gain
C
C   global 
C                       data    I/O
C       name            type    type    function
C       -------------------------------------------------------------------
C 	/ccsub/		see description include file
C       e0		real	i	error signal array
C
C==========================================================================
C	
C DESCRIPTION
C
C	Depending on the current system state, the stochastic code book
C	excitation is reduced to a level that is low enough to produce
C	positive perceptual effects, yet is high enough so as not to upset
C	the dynamics of the system.  The main effect of the method is that
C	during sustained voiced sounds, the excitation level is attenuated.
C	In unvoiced and transition regions the level is amplified to a
C	level slightly more than that of standard CELP.
C
C	The relative adaptive code book excitation component is
C	increased in voiced regions by decreasing the stochastic code book
C	excitation component.  The amount of decrease in the stochastic
C	component depends on the efficiency of the adaptive component.
C	More reconstruction burden is placed on the adaptive component as
C	its efficiency increases.  The efficiency is measured by the
C	closeness (in the squareroot crosscorrelation sense) of the residual
C	signals before and after pitch prediction.  When the efficiency is 
C       high (e.g., > 0.9), the stochastic component is amplified slightly
C	(e.g., one quantizer level).
C
C	The procedure for modifying the stochastic gain outside the
C	search loop is:
C	1)  Measure the efficiency of the adaptive component (ccor)
C	2)  Search the stochastic code book for the optimum codeword
C	3)  Modify the stochastic code book gain
C
C	This method is compatible with Federal Standard 1016
C
C
C==========================================================================
C
C CALLED BY
C
C	csub, cbsearch
C
C CALLS
C
C
C==========================================================================
C
C REFERENCES
C
C	Shoham, Yair, "Constrained-Stochastic Excitation Coding of Speech
C	at 4.8 kbps," in Advances in Speech Coding, ed. B. Atal, V.
C	Cuperman, and A. Gersho, submitted to Kluwer Academic Publishers.
C
C	Shoham, Yair, "Constrained-Stochastic Excitation Coding of Speech," 
C	Abstracts of the IEEE Workshop on Speech Coding for
C	Telecommunications, 1989, p. 65.
C
C==========================================================================
C*-
	subroutine mexcite1(l)
	implicit undefined(a-z)
	integer l
	real cgain
	include 'ccsub.com'
convex	#include "ccsub.com"
#ifdef SUNGRAPH
	include 'sungraph_var.com'
convex	#include "sungraph_var.com"
#endif
	integer i
	real e1, scale, e0save(60), ccor
c
	save e1, e0save
c
c	e1 = Euclidean norm of the first error signal
c	     (note:  the error signal array e0 is reused)
c
	e1 = 1e-6
	do 10 i = 1, l
	   e1 = e1 + e0(i)*e0(i)
	   e0save(i) = e0(i)
10	continue
	return
c----------------------------------------------------------
	entry mexcite2(l)
c
c	ccor = crosscorrelation of the residual signals before
c              and after pitch prediction
c	       (note:  the error signal array e0 is reused)
c
	ccor = 1e-6
	do 70 i = 1, l
	   ccor = ccor + e0(i)*e0save(i)
70	continue
c
c			*normalize the crosscorrelation
	ccor = ccor/e1
	return
c----------------------------------------------------------
	entry mexcite3(cgain)
c
c			*square root crosscorrelation scaling
	scale = sqrt(abs(ccor))
c
c			*modify scale
	if (scale .lt. 0.2) then
	   scale = 0.2
	else if (scale .gt. 0.9) then
	   scale = 1.4 * scale
	end if
c
c			*modify the stochastic component
	cgain = cgain*scale
c
#ifdef SUNGRAPH
	call save_sg(gain_vid, scale, 1,'save gain_vid')
	call save_sg(ccor_vid, ccor, 1,'save ccor_vid')
#endif
	return
	end
