c==========================================================================
c
c ROUTINE
c               lspdecode34
c
c FUNCTION
c                
c               independent nonuniform scalar lsp decoder 
c
c SYNOPSIS
c               subroutine lspdecode34(findex,no,freq)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c       findex		int	i	lsp frequency index
c	no		int	i	lpc order
c	freq		real	o	lsp quantized frequency
c
c==========================================================================
c
c DESCRIPTION
c
c	George Kang's tables modified for no preemphasis and bit allocation
c
C==========================================================================
C 
C INPUT FILES
C	lsp34.tbl		spectrum (34 bit LSP) coding
C
c**************************************************************************
c
	subroutine lspdecode34(findex,no,freq)
c
	implicit undefined(a-z)
	include 'ccsub.h'
convex	#include "ccsub.h"
c
	real    freq(maxno+1)
	integer no, findex(no)
	integer i, j, lsp(10, 0:15)
c
	include './lsp34.tbl'
convex	#include "./lsp34.tbl"
c
c	*** choose appropriate frequency by findex
c
	do 10 i=1, no
	   freq(i)=lsp(i,findex(i))/8000.
c	   print *,i,'freq_synth',freq(i),findex(i)
10	continue
	return
	end
