C==========================================================================
C
C ROUTINE
C               ham
C
C FUNCTION
C               creates hamming window
C
C SYNOPSIS
C               subroutine ham(win,n)
C   formal 
C
C                       data    I/O
C       name            type    type    function
C       -------------------------------------------------------------------
C       win(n)          real    i/o     hamming window
C       n               int     i       dim of win
C
C**************************************************************************
C*-
        subroutine ham(win, n)
	implicit undefined(a-z)
	integer n
        real win(n)
	integer i
	real pi
c
        pi = 4.*atan(1.0)
        do 10 i = 1, n
	   win(i) = 0.54-0.46*cos((2.*pi*(i-1))/(n-1))
10	continue
        return
        end
