c==========================================================================
c
c ROUTINE
c		gainencode2
c
c FUNCTION
c		 
c		encode and quantize code book gain
c
c SYNOPSIS
c		subroutine gainencode2(numer, denom, bits, type, index)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c	numer		i	i	code book gain numerator
c	denom		i	i	code book gain denominator
c	bits		i	i	# bits for encode
c	type		c	i	type of quantization
c	index		r	o	encoded code book gain ZERO BASED index
c	gainencode2	r	f	encoded code book gain
c
c==========================================================================
c	
c DESCRIPTION
c
c  	Fast nonuniform division for code book gain quantization to allow
c	practical quantization inside the code book search loop.  A binary
c	tree search with cross multiply quantization is implemented below.
c
C==========================================================================
C 
C INPUT FILES
C	cbgain.tbl		code book gain coding
C
c**************************************************************************
c
	real function gainencode2(numer, denom, bits, type, index)
	implicit undefined(a-z)
c
	real numer, denom
	integer bits, index
	character*10 type
c
c	Hard coded for 5 bit quantization to achieve high speed
c
	integer bit, bitm1
	parameter (bit   = 5)
	parameter (bitm1 = bit-1)
	real gainlog5(2**bit), midpoints(2**bit-1)
	integer i, shift(bitm1)
	data shift/8, 4, 2, 1/
c
	include './cbgain.tbl'
convex	#include "./cbgain.tbl"
c
ccc	if (bits .ne. bit) stop ' gainencode2:  bad bits'
c
c			*Binary tree search for closest gain
c
	index = 2**bitm1
	do 69 i = 1, bitm1
	   if (numer .gt. denom*midpoints(index)) then
	      index = index + shift(i)
	   else
	      index = index - shift(i)
	   end if
69	continue
	if (numer .gt. denom*midpoints(index)) index = index + 1
c
c			*Return quantized gain and ZERO based index
c
	gainencode2= gainlog5(index)
	index      = index - 1

	return
	end
