c==========================================================================
c
c ROUTINE
c		gaindecode
c
c FUNCTION
c		 
c		decode code book gain from the gain index (gindex),
c		bit index (bits), and quantization type (type).
c
c SYNOPSIS
c		subroutine gaindecode(gindex, bits, type, gain)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c	gindex		i	i	gain index value
c	bits		i	i	# bits for encode
c	type		c	i	type of quantization
c	gain		r	o	decoded code book gain value
c
C==========================================================================
C 
C INPUT FILES
C	cbgain.tbl		code book gain coding
C
c**************************************************************************
c
	subroutine gaindecode(gindex, bits, type, gain)
	implicit undefined(a-z)
c
	integer gindex, bits
	real gain
	character*10 type
	integer i
	real gainlog5(32), midpoints(31)
c
	include './cbgain.tbl'
convex	#include "./cbgain.tbl"
c
c	Choose appropriate gain
c
	if (bits .eq. 5) then
	   if (type .eq. 'log') then
	      gain=gainlog5(gindex+1)
	   else
	      print *,' gaindecode:  unquantized cbgain'
	   end if
	else
	   print *,' gaindecode:  unquantized cbgain'
	end if
	return
	end
