c==========================================================================
c
c ROUTINE
c               encodeham
c
c FUNCTION
c               This subroutine calculates the parity bits necessary 
c	to form the code word.
c
c
c SYNOPSIS
c               encodeham(codelength1,codelength2,hmatrix,
c			  paritybit,codeword)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c   codelength1	int	i	number of data bits 
c	codelength2	int	i	number of information bits 
c	hmatrix		int	i	vector to encode an decode by
c	paritybit	int	o	overall parity bit
c	codeword	int	o	encoded stream (paritybits at end)
c
c==========================================================================
c
c DESCRIPTION
c
c		This subroutine is part of a set of subroutines which perform
c	a Generalized Hamming Code.  As you know, Hamming codes are perfect
c	codes and can only detect and correct one error.  We added an overall
c 	parity checkbit, which allows us to detect 2 errors.  When 2 errors 
c	are detected, (in subroutine dcodham.f) no correction attempt is
c	made.  This would most likely result in more errors.  Instead, a flag
c	is sent to the calling program notifying it of multiple errors so
c	that smoothing may be attempted.  The Hamming codes presently supported
c	by the routines are (63,57), (31,26), (15,11), and shortened variations
c	thereof.  It could be made even more general by making minor modifications
c	to the dectobin.f subroutine.  This routine at present will calculate 
c	a maximum of 6 bits.
c
c	Hamming routines consist of the following files:
c
c		matrixgen - generates the hmatrix and sydrometable.
c		dectobin - does a simple decimal to binary conversion.
c		encodeham - generates the code word and overall paritybit.
c		decodeham - recovers infobits, checks for errors, corrects 1
c					error, and sends out flag for smoothing.
c
c 
c               This subroutine performs the Hamming encode function.
c	It will calculate the necessary parity bits, depending on which code
c	is requested, and will add the overall parity bit to the end of the 
c	code word generated.
c
c
c==========================================================================
c	
c REFERENCES
c
c	Lin and Costello : Error Control Coding
c	Berlekamp : Algebraic Coding Theory
c
c**************************************************************************
c
	subroutine encodeham(codelength1,codelength2,hmatrix,
     1     paritybit,codeword)
	implicit undefined(a-z)
c
	integer codelength1,codelength2,paritybit
	integer codeword(codelength1),hmatrix(codelength1)
	integer parityflag,temp1,temp2,i,temp3
c
	paritybit=0
	parityflag=1
	temp1=codelength1-codelength2
	temp2=0
	temp3=0
c
c	First generate the parity bits for the Hamming code word.  This is
c	relatively straightforward.  hmatrix was generated in matrixgen.f,
c	which is called as part of the Hamming initialization routines.
c
	do 10 i=1, codelength2
	   if(codeword(i).ne.0) temp2= temp2 .xor. hmatrix(i)
10	continue
c
c	since the hmatrix is stored in a packed decimal format, the parity
c	bits must be unpacked and appended to the end of the bitsteam.
c	after this routine you will have the complete code word.
c
	call dectobin(temp1,temp2,codeword(codelength2+1))
c
c	Now I check to see if the parityflag is set, indicating the user
c	requests an overall parity bit be generated.  Normally this will
c	be the case.
c
	temp2=0
	if (parityflag.eq.1)then
	   do 20 i=1,codelength1
	      temp2 = temp2 .xor. codeword(i)
	      if (codeword(i).ne.0) temp3=temp3+1
20	   continue
	   paritybit=temp2
	end if
c
	return
	end


