c==========================================================================
c
c ROUTINE
c		dcodpg.f
c
c FUNCTION
c		 Decodes all pitch gain values values for a frame
c		
c
c SYNOPSIS
c		subroutine dcodpg(pgbits,pgtype,bitsum1,bitsum2,bitpointer,
c				  nn,stream,streambits,pgs)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c	pgbits		int	i	number of bits for quantization
c	pgtype		char	i	quantizer type
c	bitsum1		int	i	number of bits for odd subframes
c	bitsum2		int	i	number of bits for even subframes
c	bitpointer	int	i	number of bits used
c	nn		int	i	number of subframes/frame
c	stream		int	i	bit stream
c	streambits	int	i	number of bits in stream
c	pgs		real	o	vector of pitch gains
c
c==========================================================================
c
c DESCRIPTION
c
c
c==========================================================================
c
c REFERENCES
c
c
c**************************************************************************
c
	subroutine dcodpg(pgbits,pgtype,bitsum1,bitsum2,bitpointer,nn,stream,
     &                      streambits,pgs)
	implicit undefined(a-z)
c
	integer pgbits,bitsum1,bitsum2,bitpointer,nn,streambits
	integer*2 stream(streambits)
	real pgs(nn),temp
	character*10 pgtype
	integer i,pointer,index
c
	pointer=bitpointer
	do 10 i=1,nn
	   call unpack(stream,pgbits,streambits,index,pointer)
	   call pitchdecode(index,pgbits,pgtype,temp)
	   pgs(i)=temp
	   if (i.eq.1 .or. i.eq.3 .or. i.eq.5) then
	      pointer=pointer+bitsum2-pgbits
	   else if (i.eq.2 .or. i.eq.4 .or. i.eq.6) then
	      pointer=pointer+bitsum1-pgbits
	   else
	      print *,' dcodpg:  Error in decoding pitch gain'
	   end if
10	continue
	bitpointer=bitpointer+pgbits
	return
	end
