c==========================================================================
c
c ROUTINE
c		dcodcbi.f
c
c FUNCTION
c		 Decodes all code book indicies for a frame
c		
c
c SYNOPSIS
c		subroutine dcodcbi(cbbits,bitsum1,bitsum2,nn,cbi)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c	cbbits		int	i	number of bits for quantization
c	bitsum1		int	i	number of bits for odd subframes
c	bitsum2		int	i	number of bits for even subframes
c	bitpointer	int	i/o	number of bits used
c	nn		int	i	number of subframes/frame
c	stream		int*2	i	bit stream
c	streambits	int	i	number of bits in stream
c	cbi		int	o	vector of code book indicies
c
c==========================================================================
c
c DESCRIPTION
c
c
c==========================================================================
c
c REFERENCES
c
c
c**************************************************************************
c
	subroutine dcodcbi(cbbits,bitsum1,bitsum2,bitpointer,nn,stream,
     &                      streambits,cbi)
	implicit undefined(a-z)
c
	integer cbbits,bitsum1,bitsum2,bitpointer,nn,streambits
	integer*2 stream(streambits)
	integer cbi(nn),i,pointer
c
	pointer=bitpointer
	do 10 i=1,nn
	   call unpack(stream,cbbits,streambits,cbi(i),pointer)
	   cbi(i)=cbi(i)+1
	   if (i.eq.1 .or. i.eq.3 .or. i.eq.5) then
	      pointer=pointer+bitsum2-cbbits
	   else if (i.eq.2 .or. i.eq.4 .or. i.eq.6) then
	      pointer=pointer+bitsum1-cbbits
	   else
	      print *,' dcodcbi:  Error in decoding code book index'
	   end if
10	continue
	bitpointer=bitpointer+cbbits
	return
	end
