C==========================================================================
C
C ROUTINE
C               csub
C
C FUNCTION
C               control routine to find optimal excitation
C		(adaptive and stochastic code book searches)
C
C SYNOPSIS
C               subroutine csub(s,v,l,lp)
C
C   formal 
C
C                       data    I/O
C       name            type    type    function
C       -------------------------------------------------------------------
C       s(l)            real    i       speech or residual segment
C       v(l)            real    o       optimum excitation vector
C       l               int     i       stochastic analysis frame size
C	lp		int	i	adaptive (pitch) analysis frame size
C
C   global 
C                       data    I/O
C       name            type    type    function
C       -------------------------------------------------------------------
C 	/ccsub/       	see description include file
#ifdef SUNGRAPH
C 	/sungraph_var/
#endif
C
C==========================================================================
C*-
        subroutine csub(s,v,l,lp)
	implicit undefined(a-z)
	integer l, lp
	real s(l), v(l)
	include 'ccsub.com'
convex	#include "ccsub.com"
#ifdef SUNGRAPH
	include 'sungraph_var.com'
convex	#include "sungraph_var.com"
#endif
c
c			*find the initial error without pitch VQ
	call setr(l,0.0,e0)
	call confg(s,l,d1a,d2a,d3a,d4a,0,1,1,1)
	call movefr(no+1,d2b,d2a)
	call movefr(no+1,d3b,d3a)
	call movefr(no+1,d4b,d4a)
c
c			*find impulse response (h) of
c			*perceptual weighting filter
	call impulse(l)
c
c			*norm of first error signal for const. exc.
	if (mxsw) call mexcite1(l)
c
c			*pitch (adaptive code book) search
c	Get pp parameters every segment if lp = l.
c	If lp <> l then get pp parameters on odd segments.
c
	if(lp .eq. l) then
	   call psearch(s, l)
	else
	   if(mod(nseg, 2) .eq. 1) call psearch(s, lp)
	end if
#ifdef SUNGRAPH
	call save_sg(fndpp_e0_vid, e0, l,'save fndpp_e0_vid')
#endif
c
c			*find initial error with pitch VQ
        call setr(l,0.0,e0)
        call confg(s,l,d1a,d2a,d3a,d4a,1,1,1,1)
#ifdef SUNGRAPH
	call save_sg(fndex_e0_vid, e0, l,'save fndex_e0_vid')
#endif
c
c			*norm of second error signal for const. exc.
	if (mxsw) call mexcite2(l)
c
c			*stochastic code book search
        call cbsearch(s,l,v)
c
c			*update filter states
        call movefr(l,v,e0)
        call confg(s,l,d1b,d2b,d3b,d4b,1,1,1,1)
        call movefr(idb,d1b,d1a)
        call movefr(no+1,d2b,d2a)
        call movefr(no+1,d3b,d3a)
        call movefr(no+1,d4b,d4a)
        return
        end
