c==========================================================================
c
c NAME
c	cor
c
c FUNCTION
c
c	compute auto-correlation coefficients by direct multiplication
c
c SYNOPSIS
c
c	subroutine cor(rar, idim, n, c0, c)
c
c   formal 
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c       rar             real    i       Input data frame
c       idim            int     i       frame size
c       n               int     i       Number of correlation terms, 
c                                       exclusive C0
c       c0              real    o       C(0)
c       c               real    o       Auto correlation terms C(i), i=1,n
c       
c==========================================================================
c       
c DESCRIPTION
c
c       COR computes the autocorrelation coefficients of the data
c       sequence rar according to the following formula:
c
c              idim
c       C(i) = SUM   rar(k) * rar(k-i)   , where i = 0, ..., n lags
c              k=i+1
c
c       c0 = C(0)
c
c	NOTE:  rar(k-i) is truncated, so C(i) are true autocorrelations.
c
c**************************************************************************
c-
	subroutine cor(rar, idim, n, c0, c)
	implicit undefined(a-z)
	integer idim, n
	real rar(idim), c0, c(n)
	integer i, k
c
	c0 = 0.0
c
	do 5 i = 1, idim
	   c0 = c0 + rar(i)*rar(i)
5	continue
c
	do 15 i = 1, n
	   c(i) = 0.0
	   do 10 k = i+1, idim
	      c(i) = c(i) + rar(k)*rar(k-i)
10	   continue
15	continue
c
	return
	end
