C==========================================================================
C
C ROUTINE
C               clip
C
C FUNCTION
C		determine if speech is clipped
C
C SYNOPSIS
C               function clip(s, l)
C
C   formal 
C
C                       data    I/O
C       name            type    type    function
C       -------------------------------------------------------------------
C	s		real	i	input speech
C	l		int	i	length of input speech
C       clip		logical	o	clip flag
C
C==========================================================================
C*-
        function clip(s, l)
	implicit undefined(a-z)
	integer l
        real s(l)
	logical clip
	real sum
	integer i, count
c
c	Count number of clippings and sum their magnitudes
c
	count = 0
	sum = 0.
	do 69 i = 1, l
	   if (abs(s(i)) .gt. 32768.0) then
	      count = count + 1
	      sum = sum + abs(s(i))
	   end if
69	continue
c
c	Clipping heuristics (could also use energy, delta energy, etc.)
c
	clip = .false.
	if ((count .ge. 10) .or. (count.ge.5 .and. sum.gt.1.e6)) then
	   clip = .true.
	end if
        return
	end
