C==========================================================================
C
C ROUTINE
C               cbsearch
C
C FUNCTION
C               find optimal MSPE excitation code word
C
C SYNOPSIS
C               subroutine cbsearch(s, l, v)
C
C   formal 
C
C                       data    I/O
C       name            type    type    function
C       -------------------------------------------------------------------
C       s(l)            real    i       data segment
C       l               int     i       length of vectors
C       v(l)            real    o       optimum excitation segment found
C
C   global 
C                       data    I/O
C       name            type    type    function
C       -------------------------------------------------------------------
C 	/ccsub/       see description include file
C	x(maxcode)	real	i	code book
#ifdef SUNGRAPH
C 	/sungraph_var/
#endif
C
C==========================================================================
C	
C DESCRIPTION
C
C  Code book search is performed by closed-loop analysis using conventional
C  minimum squared prediction error (MSPE) criteria of the perceptually
C  weighted error signal.  The code book is overlaped to allow recursive
C  computational savings in routine cgain:
C
C	index	code book
C		+-----------------------+
C	1	| 2M-1         2(M-1)+L |
C	2	| 2(M-2)+1     2(M-2)+L |
C	:	| :            :	|
C	N-1	| .            .	|
C	N	| .            .	|
C	:	| 3            62	|
C	:	| 1            60	|
C		+-----------------------+
C
C	where: M = maximum code book size
C	       N = actual code book search size (any value between 1 & M)
C	       L = code word length
C
C	each code word is:  2(M-index)+1 -> 2(M-index)+L
C  	
C==========================================================================
C
C CALLED BY
C
C       csub
C
C CALLS
C
C	cgain, [gainencode], mexcite3
C
C==========================================================================
C
C REFERENCES
C
C	Tremain, Thomas E., Joseph P. Campbell, Jr and Vanoy C. Welch,
C	"A 4.8 kbps Code Excited Linear Predictive Coder," Proceedings
C	of the Mobile Satellite Conference, 3-5 May 1988, pp. 491-496.
C
C	Campbell, Joseph P. Jr., Vanoy C. Welch and Thomas E. Tremain,
C	"An Expandable Error-Protected 4800 bps CELP Coder (U.S. Federal
C	Standard 4800 bps Voice Coder)," Proceedings of ICASSP, 1989.
C	(and Proceedings of Speech Tech, 1989.)
C
C**************************************************************************
C*-
	subroutine cbsearch(s, l, v)
	implicit undefined(a-z)
	integer l
	real s(l), v(l)
	include 'ccsub.com'
convex	#include "ccsub.com"
#ifdef SUNGRAPH
	include 'sungraph_var.com'
convex	#include "sungraph_var.com"
	real dbcon
#endif
	integer i, codeword, len
	real emax, cgain, gainencode, quangain, oldgain
c
c			*length of truncated impulse response
	parameter (len = 30)
#ifdef SUNGRAPH
c			*save impulse response in file 'codebook'
c			*(same as impulse response in file 'pitch')
	call save_sg(cb_ir_vid,h,l,'save cb_ir_vid')
#endif
c
c			*find gain and -error term for each codeword
c			*and search for best code word (max -error term)
c			*(codewords are overlapped by shifts of -2
c			* along the code vector x)
c			*NOTE: gain(i) & err(i) can be replaced by scalars
	codeword= 2*maxncsize-1
	cbindex = 1
	gain(1) = cgain(x(codeword), l, .true., len, err(1))
	emax    = err(1)
	codeword= codeword-2
	do 10 i = 2, ncsize
	   gain(i)  = cgain(x(codeword), l, .false., len, err(i))
	   codeword = codeword-2
	   if (err(i) .gt. emax) then
	      emax    = err(i)
	      cbindex = i
	   end if
10	continue
c	if (err(cbindex).lt.0.0)print *,' CB match<0',frame,err(cbindex)
c
c			*pointer to best code word
	codeword = 2*(maxncsize-cbindex)+1
c
c			*OPTIONAL (may be useful for integer DSPs)
c			*given best code word, recompute its gain to
c			*correct any errors accumulated in recursions
	gain(cbindex) = cgain(x(codeword), l, .true., l, err(cbindex))
c
c			*write cbgain.data file for quantizer design
c			*Open loop quant REQUIRED!
copt	write (20,*) gain(cbindex)
#ifdef SUNGRAPH
c			*save code book gain in file 'codebook'
c			*if closed-loop quant, this is QUANTIZED gain
	call save_sg(cb_gain_vid,gain(cbindex),1,'save cb_gain_vid')
c
c			*save code book error in file 'codebook'
	call save_sg(cb_match_vid,err,ncsize,'save cb_error_vid')
#endif
	oldgain = gain(cbindex)
c
c			*constrained excitation
	if (mxsw) call mexcite3(gain(cbindex))
c
c			*gain quantization, UNNECESSARY for closed-loop quant
	if (cbgtype .ne. 'none') then
	   if (cbgbits .eq. 5) then
	      gain(cbindex) = gainencode(gain(cbindex),cbgbits,cbgtype,gindex)
	   end if
	else
	   print *,' cbsearch:  not quantizing cbgain'
	end if
c
c			*scale selected code word vector -> excitation array
c			*call VDECODE?
	do 70 i = 0, l-1
	   v(i+1) = gain(cbindex)*x(i+codeword)
70	continue
#ifdef SUNGRAPH
c			*save quantized code book gain in file 'codebook'
	if (oldgain .ne. 0) then
	   dbcon=20.*log10(abs(oldgain/gain(cbindex)))
	end if
	quangain=gain(cbindex)
	call save_sg(cb_qgain_vid,quangain,1,'save cb_qgain_vid')
	call save_sg(dbcon_vid,dbcon,1,'save dbcon_vid')
c
c			*save code book excitation in file 'codebook'
	call save_sg(cb_exc_vid,v,l,'save cb_exc_vid')
#endif
	return
	end
