c==========================================================================
c
c ROUTINE
c               biterror
c
c FUNCTION
c                
c               introduce random errors in CELP bitstream
c
c SYNOPSIS
c               biterror(ber,mask,frame,stream,streambits,error,total)
c
c   formal 
c
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c       ber		real	i	bit error rate
c	mask		int	i	error mask
c	frame		int	i	frame number
c	stream		int*2	i/o	array of binary bits to be corrupted
c	streambits	int	i	number of bits in stream
c	error		int	o	number of bits corrputed
c	total		int	o	total number of bits through coder
c
c==========================================================================
c
c DESCRIPTION
c		Bit errors are introduced into the array "stream" at a rate
c	"ber".  Individual bits may be reversed while protecting others by
c	setting bits of the mask array which is read at the beginning of 
c	execution.  
c		To protect a bit set mask(bit) = 1.  If this is 
c	left at 0, the bit is subjected to reversal at the rate specified
c	by "ber".  (The protection scheme above is NOT a function of the 
c	Hamming error control coding.)
c
c**************************************************************************
c
	subroutine biterror(ber,mask,frame,stream,streambits,error,total)
c
	implicit undefined(a-z)
	integer streambits
	integer frame,error,total
	integer*2 stream(streambits)
	real ber
	integer i, mask(172), random
	real xx, realrate, rate
c
c	*** protection mask: read in
c
	rate=ber/100.
	do 10 i=1, streambits
	   xx=(float(random()+32768))/65535.
	   if (mask(i) .eq. 0) then
	      total=total+1
	      if (xx .lt. rate) then
		 stream(i)=stream(i) .xor. 1
	         if (stream(i) .ne. 0 .and. stream(i) .ne. 1) then
	            stop ' biterror:  bit stream not ones and zeros'
	         end if
	         error=error+1
	         realrate=100.*float(error)/float(total)
c	         type 20,frame,i,realrate
c20		 format(' In frame number ',i5, ' error at bit ',
c     1          i3,', current BER = ',f8.4,' %')
	      end if
	   end if
10	continue
	return
	end
	
	   
