c==========================================================================
c
c NAME
c	actorc  
c
c FUNCTION
c
c	Schur recursion to do autocorrelation analysis.
c	Converts autocorrelation sequence to reflection coefficients.
c
c SYNOPSIS
c
c	subroutine actorc (c0, c, rc, n, err)
c
c   formal 
c                       data    I/O
c       name            type    type    function
c       -------------------------------------------------------------------
c       c0              real    i       c(0)
c	c(n)		real	i	auto-correlation coefficients
c       rc(n)		real    o       reflection coefficients (voiced-> +rc1)
c       n               int     i       number of reflection coefficients
c	err		real	o	normalized prediction error
c       
c==========================================================================
c       
c DESCRIPTION
c
c       This performs the classical Schur recursion (rediscovered by
c	LeRoux & Guegen) on the correlation sequence c0, c(1), c(2) . . .
c	to obtain n reflection coefficients (rc).  The recursion can be
c	performed entirely in fractional arithemetic because the
c	correlation sequence is normalized by c0, so all the quantities
c	in the recursion are less than unity magnitude (except c0).
c
c	The sign convention used defines the first reflection coefficient
c	as the normalized first autocorrelation coefficient, which results
c	in positive values of rc(1) for voiced speech.
c
c==========================================================================
c       
c REFERENCES
c
c	Parsons, Voice and Speech Processing, McGraw-Hill, 1987, p.160&378.
c
c==========================================================================
c       
c EXAMPLES
c
c	call cor(data,np,c0,c,n)
c	call actorc(c0,c,rc,n)
c==========================================================================
c
c PROCESS DESCRIPTION
c
c       Name    Type    Function
c
c       d       real      Recursion sequence (dim n)
c       g       real      Recursion sequence (dim n)
c       p       int       Orderindex recursion
c       err     real      Backward error
c       err0    real      Backward error of order 0
c
c**************************************************************************
c-
        subroutine actorc (c0, c, rc, n, err)
	implicit undefined(a-z)
	integer n
        real c0, c(n), rc(n), err
	include 'ccsub.h'
convex	#include "ccsub.h"
	real d(maxno), g(maxno), rch
        integer i, p
c
c	If zero energy, set rc's to zero & return
c
	if (c0 .le. 0.0) then
	   do 10 i = 1, n
	      rc(i) = 0.0
10	   continue
	   return
	end if
c
	do 30 i = 1, n
	   d(i) = c(i)/c0
	   g(i) = d(i)
30	continue
	rch   = g(1)
	rc(1) = rch
	err   = 1.-rch*rch
c
	do 100 p = 1, n-1
	   do 50 i = 1, n-p
	      g(i) = g(i+1) - rch*d(i)
	      d(i) = d(i) - rch*g(i+1)
50	   continue
c	   Extract the reflection coefficient
	   rch     = g(1)/err
	   rc(p+1) = rch
c	   The mean squares error recursion
	   err = err*(1.-rch*rch)
100	continue
	return
	end
