#include "graph.h"

/*			BREADTH_GRAPH_

    The constructor passes the start node, goal node and the number of
    operators to SEARCH_.

*/

BREADTH_GRAPH_::BREADTH_GRAPH_(NODE_ *start, NODE_ *goal, int op)
    :SEARCH_(start, goal, op)
{
}



/*			ADD

    Adds a node to the search graph, only if it's not already in the
    graph.

*/

int BREADTH_GRAPH_::add(NODE_ *succ)
{
    if (!closed.lookup(*succ) && !open.lookup(*succ))
// if successor is neither on closed nor open add it to the TAIL of open
    {
        open.addtotail(*succ);
        return(1);
    }
    return(0);
}
