#ifndef _OBJECT_H_
#define _OBJECT_H_

#include <stdio.h>

/*
                     VOBJECT_

    The abstract class VOBJECT_ is used by several other classes,
    notably by container classes like LIST_ that stores (pointers to)
    VOBJECT_ 's. Therefore, user-defined classes that make use of class
    LIST_ need to derive their objects (that are to be stored in the list
    object) from VOBJECT_. As a consequence these objects must implement
    the virtual funcion equal().
 
*/

class VOBJECT_
{
    public:
        virtual ~VOBJECT_();
        virtual int equal(const VOBJECT_ &) const = 0;
	    // returns 1 : objects are equal, or 0 : objects are not equal 
};



/*
		 SVOBJECT_

    SVOBJECT_ is an extension of VOBJECT_, it is used by class
    SORTEDLIST_ that creates a sorted list of (pointers to) SVOBJECT_.
    Objects derived from SVOBJECT_ must implement at least function
    eval() which is used to determine the order of two objects.

*/

class SVOBJECT_ : public VOBJECT_	// sortable object
{
    public:
	~SVOBJECT_();
	virtual int eval(const SVOBJECT_ &) const = 0;
	    // returns < 0 : object precedes other object 
            // returns > 0 : object comes after other object  
 	    // returns 0   : doesn't matter (objects rank equally high)  
};

#endif


