;;;
;;; Adapted from the Prodigy2 domain, 25/1/92 aperez
;;;

;;; Notes about this version:
;;; -no locations (i.e. no "at" predicate, no numbers)
;;; -if something is pickud up by the robot, it is not next-to
;;; anything (i.e. (holding x) --> (~(next-to x y))  PICKUP-OBJ
;;; -the robot cannot be holding two things at a time (PICKUP-OBJ)
;;; -next-to not transitive: see PUTDOWN
;;; -next-to symmetric: see PUTDOWN-NEXT-TO, PUSH-BOX

;;; 10/2/92 aperez
;;; Removed conditional effects lhs's.
;;; Added boxes to get a deeper type hierarchy. Only boxes are
;;; pushable. 

(create-problem-space 'extended-strips :current t)

(ptype-of OBJECT :top-type)
(ptype-of BOX    OBJECT)
(ptype-of KEY    OBJECT)
(ptype-of ROOM   :top-type)
(ptype-of DOOR   :top-type)
(ptype-of LOCX   :top-type)
(ptype-of LOCY   :top-type)
(ptype-of Robot  :top-type)
(ptype-of Status :top-type)

(pinstance-of ROBOT Robot)
(pinstance-of OPEN  Status)
(pinstance-of CLOSED Status)

(setf *new-ops*
'((new-op operator op-1
  (params <v1> <v11> <v10> <v9> <v8> <v7> <v6> <v5> <v4> <v3> <v2>)
  (preconds
   ((<v1> door) (<v11> room) (<v10> door) (<v9> door) (<v8> room) (<v7> object)
    (<v6> object) (<v5> room) (<v4> object) (<v3> room) (<v2> door))
   (and (dr-open <v2>) (dr-open <v1>) (arm-empty) (inroom robot <v3>)
        (inroom <v4> <v5>) (inroom <v6> <v5>) (inroom <v7> <v8>)
        (dr-closed <v9>) (dr-closed <v10>) (unlocked <v9>)
        (connects <v2> <v3> <v11>) (connects <v1> <v3> <v5>)
        (connects <v9> <v5> <v8>) (connects <v10> <v11> <v8>)
        (connects <v10> <v8> <v11>) (connects <v9> <v8> <v5>)
        (connects <v1> <v5> <v3>) (connects <v2> <v11> <v3>) (pushable <v4>)
        (pushable <v6>) (pushable <v7>) (locked <v10>) (dr-to-rm <v2> <v3>)
        (dr-to-rm <v2> <v11>) (dr-to-rm <v1> <v3>) (dr-to-rm <v1> <v5>)
        (dr-to-rm <v9> <v5>) (dr-to-rm <v9> <v8>) (dr-to-rm <v10> <v11>)
        (dr-to-rm <v10> <v8>)))
   (effects nil ((add (next-to robot <v1>))))
   (goto-dr))
 (new-op operator op-2
  (params <v16> <v17> <v18> <v14> <v20> <v22> <v19> <v21> <v15> <v13> <v12>)
  (preconds
   ((<v16> object) (<v17> object) (<v18> object) (<v14> door) (<v20> door)
    (<v22> room) (<v19> room) (<v21> door) (<v15> door) (<v13> room)
    (<v12> room))
   (and (inroom robot <v13>) (arm-empty) (dr-open <v15>) (inroom <v16> <v12>)
        (inroom <v17> <v12>) (inroom <v18> <v19>) (dr-closed <v20>)
        (dr-closed <v21>) (connects <v15> <v13> <v12>)
        (connects <v15> <v12> <v13>) (pushable <v16>) (pushable <v17>)
        (pushable <v18>) (locked <v21>) (dr-to-rm <v14> <v22>)
        (dr-to-rm <v15> <v13>) (dr-to-rm <v15> <v12>) (dr-to-rm <v20> <v12>)
        (dr-to-rm <v20> <v19>) (dr-to-rm <v21> <v22>) (dr-to-rm <v21> <v19>)
        (next-to robot <v15>)))
  (effects nil ((add (inroom robot <v12>)) (del (inroom robot <v13>))))
  (go-thru-dr  go-thru-dr))
 (new-op operator op-3
  (params <v24> <v23> <v33> <v32> <v31> <v30> <v29> <v28> <v27> <v26> <v25>)
  (preconds
   ((<v24> door) (<v23> door) (<v33> room) (<v32> room) (<v31> door)
    (<v30> room) (<v29> object) (<v28> object) (<v27> room) (<v26> object)
    (<v25> door))
   (and (dr-open <v25>) (dr-open <v24>) (arm-empty) (inroom <v26> <v27>)
        (inroom <v28> <v27>) (inroom <v29> <v30>) (inroom robot <v27>)
        (dr-closed <v23>) (dr-closed <v31>) (unlocked <v23>)
        (connects <v25> <v32> <v33>) (connects <v24> <v32> <v27>)
        (connects <v23> <v27> <v30>) (connects <v31> <v33> <v30>)
        (connects <v31> <v30> <v33>) (connects <v23> <v30> <v27>)
        (connects <v24> <v27> <v32>) (connects <v25> <v33> <v32>)
        (pushable <v26>) (pushable <v28>) (pushable <v29>) (locked <v31>)
        (dr-to-rm <v25> <v32>) (dr-to-rm <v25> <v33>) (dr-to-rm <v24> <v32>)
        (dr-to-rm <v24> <v27>) (dr-to-rm <v23> <v27>) (dr-to-rm <v23> <v30>)
        (dr-to-rm <v31> <v33>) (dr-to-rm <v31> <v30>) (next-to robot <v24>)))
  (effects nil ((add (next-to robot <v23>)) (del (next-to robot <v24>))))
  (goto-dr))
 (new-op operator op-4
  (params <v34> <v44> <v43> <v42> <v41> <v40> <v39> <v38> <v37> <v36> <v35>)
  (preconds
   ((<v34> door) (<v44> room) (<v43> room) (<v42> door) (<v41> room)
    (<v40> object) (<v39> object) (<v38> room) (<v37> object) (<v36> door)
    (<v35> door))
   (and (dr-open <v35>) (dr-open <v36>) (arm-empty) (inroom <v37> <v38>)
        (inroom <v39> <v38>) (inroom <v40> <v41>) (inroom robot <v38>)
        (dr-closed <v34>) (dr-closed <v42>) (unlocked <v34>)
        (connects <v35> <v43> <v44>) (connects <v36> <v43> <v38>)
        (connects <v34> <v38> <v41>) (connects <v42> <v44> <v41>)
        (connects <v42> <v41> <v44>) (connects <v34> <v41> <v38>)
        (connects <v36> <v38> <v43>) (connects <v35> <v44> <v43>)
        (pushable <v37>) (pushable <v39>) (pushable <v40>) (locked <v42>)
        (dr-to-rm <v35> <v43>) (dr-to-rm <v35> <v44>) (dr-to-rm <v36> <v43>)
        (dr-to-rm <v36> <v38>) (dr-to-rm <v34> <v38>) (dr-to-rm <v34> <v41>)
        (dr-to-rm <v42> <v44>) (dr-to-rm <v42> <v41>) (next-to robot <v34>)))
  (effects nil ((add (dr-open <v34>)) (del (dr-closed <v34>))))
  (open-door))
 (new-op operator op-5
  (params <v45> <v55> <v54> <v53> <v52> <v51> <v50> <v49> <v48> <v47> <v46>)
  (preconds
   ((<v45> door) (<v55> room) (<v54> room) (<v53> door) (<v52> room)
    (<v51> object) (<v50> object) (<v49> room) (<v48> object) (<v47> door)
    (<v46> door))
   (and (dr-open <v46>) (dr-open <v47>) (dr-open <v45>) (arm-empty)
        (inroom <v48> <v49>) (inroom <v50> <v49>) (inroom <v51> <v52>)
        (inroom robot <v52>) (dr-closed <v53>) (unlocked <v45>)
        (connects <v46> <v54> <v55>) (connects <v47> <v54> <v49>)
        (connects <v45> <v49> <v52>) (connects <v53> <v55> <v52>)
        (connects <v53> <v52> <v55>) (connects <v45> <v52> <v49>)
        (connects <v47> <v49> <v54>) (connects <v46> <v55> <v54>)
        (pushable <v48>) (pushable <v50>) (pushable <v51>) (locked <v53>)
        (dr-to-rm <v46> <v54>) (dr-to-rm <v46> <v55>) (dr-to-rm <v47> <v54>)
        (dr-to-rm <v47> <v49>) (dr-to-rm <v45> <v49>) (dr-to-rm <v45> <v52>)
        (dr-to-rm <v53> <v55>) (dr-to-rm <v53> <v52>) (next-to robot <v45>)))
  (effects nil ((add (dr-closed <v45>)) (del (dr-open <v45>))))
  (close-door))
 (new-op operator op-6
  (params <v57> <v56> <v66> <v65> <v64> <v63> <v62> <v61> <v60> <v59> <v58>)
  (preconds
   ((<v57> door) (<v56> object) (<v66> room) (<v65> room) (<v64> door)
    (<v63> room) (<v62> object) (<v61> room) (<v60> object) (<v59> door)
    (<v58> door))
   (and (dr-open <v58>) (dr-open <v59>) (arm-empty) (inroom <v60> <v61>)
        (inroom <v62> <v61>) (inroom <v56> <v63>) (inroom robot <v63>)
        (dr-closed <v57>) (dr-closed <v64>) (unlocked <v57>)
        (connects <v58> <v65> <v66>) (connects <v59> <v65> <v61>)
        (connects <v57> <v61> <v63>) (connects <v64> <v66> <v63>)
        (connects <v64> <v63> <v66>) (connects <v57> <v63> <v61>)
        (connects <v59> <v61> <v65>) (connects <v58> <v66> <v65>)
        (pushable <v60>) (pushable <v62>) (pushable <v56>) (locked <v64>)
        (dr-to-rm <v58> <v65>) (dr-to-rm <v58> <v66>) (dr-to-rm <v59> <v65>)
        (dr-to-rm <v59> <v61>) (dr-to-rm <v57> <v61>) (dr-to-rm <v57> <v63>)
        (dr-to-rm <v64> <v66>) (dr-to-rm <v64> <v63>) (next-to robot <v57>)))
  (effects nil ((add (next-to robot <v56>)) (del (next-to robot <v57>))))
  (goto-obj))))


(setf real-ops
     '((operator go-thru-dr
 (params <ddx> <rrx> <rry>)
 (preconds
  ((<ddx> door)
   (<rrx> room)
   (<rry> room))
  (and (arm-empty)
       (dr-to-rm <ddx> <rrx>)
       (dr-open <ddx>)
       (next-to robot <ddx>)
       (connects <ddx> <rrx> <rry>)
       (inroom robot <rrx>)))
 (effects
  ((<other> object))
  ((del (next-to robot <other>))
   (del (inroom robot <rrx>))
   (add (inroom robot <rry>)))))

(operator goto-dr
 (params <dx> <rx>)
 (preconds
  ((<dx> door)
   (<rx> room))
  (and (dr-to-rm <dx> <rx>)
       (inroom robot <rx>)))
 (effects
  ((<other> (or object door)))
  ((del (next-to robot <other>))
   (add (next-to robot <dx>)))))
       

(operator goto-obj
 (params <b> <rm>) 
 (preconds
  ((<b>  object)
   (<rm> room))
  (and (inroom <b> <rm>)
       (inroom robot <rm>)))
 (effects
  ((<other>  (or object door)))
  ((del (next-to robot <other>))
;  (if (next-to robot <other>) ((del (next-to robot <other>))))
   (add (next-to robot <b>)))))

(operator open-door 
 (params <door>)
 (preconds
  ((<door> door))
  (and (next-to robot <door>)
       (unlocked <door>)
       (dr-closed <door>)))
 (effects
  ()
  ((del (dr-closed <door>))
   (add (dr-open <door>)))))


(operator close-door
 (params <door1>)
 (preconds
  ((<door1> door))
  (and (next-to robot <door1>)
       (dr-open <door1>)))
 (effects
  ()
  ((del (dr-open <door1>))
   (add (dr-closed <door1>)))))))
