#|
*******************************************************************************
PRODIGY Version 2.0  
Copyright 1989 by Steven Minton, Craig Knoblock, Dan Kuokka and Jaime Carbonell

The PRODIGY System was designed and built by Steven Minton, Craig Knoblock,
Dan Kuokka and Jaime Carbonell.  Additional contributors include Henrik Nordin,
Yolanda Gil, Manuela Veloso, Robert Joseph, Santiago Rementeria, Alicia Perez, 
Ellen Riloff, Michael Miller, and Dan Kahn.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#



(proclaim '(special *DOMAINS-PATH* *PLANNER-PATH* *DISPLAY-ENV* *FEATURES*))

;These variables must be set by the system installer.  Please see the
;README file for more information.
(setq *DOMAINS-PATH* (pathname "/usr/prodigy/domains/"))
(setq *PLANNER-PATH* (pathname "/usr/prodigy/system/planner/"))

;; 
;;  lisp load environment specifications...
;;
;;; allegro (franz) doesn't like :downcase in some versions because the
;;; defstruct is messed up and it creates access functions with lowercase
;;; names.  I don't know what the story is with lucid.
#-(or :franz-inc :lucid) (setf *print-case* :downcase)  

;; 
;;  file interface functions...
;;

(defun load-path (path file)
  "to access related files from a central directory"
  (let ((*default-pathname-defaults* path))
    (load file)))

; optional, we like to have the system print-out as files are loaded
(setq *load-verbose* t)

;;
;;  the planner
;; 

(load-path *PLANNER-PATH* "ini") 
(load-path *PLANNER-PATH* "g-map")
(load-path *PLANNER-PATH* "g-loop")
(load-path *PLANNER-PATH* "data-types")
(load-path *PLANNER-PATH* "misc")
(load-path *PLANNER-PATH* "checks")
(load-path *PLANNER-PATH* "matching")
(load-path *PLANNER-PATH* "engine")
(load-path *PLANNER-PATH* "output")
(load-path *PLANNER-PATH* "treetrek")
(load-path *PLANNER-PATH* "load-domain")
(load-path *PLANNER-PATH* "meta-fns")
(load-path *PLANNER-PATH* "adjust")
(load-path *PLANNER-PATH* "scntrl")

;;
;; graphics 
;;

(cond ((member :coral *features*)
       (load-path *PLANNER-PATH* "pg-mac"))
      
      ((and (or (member :cmu *features*)
		(member :franz-inc *features*)
		(member :lucid *features*))
	   (find-package "XLIB") 
	    *DISPLAY-ENV*)

		   (load-path *PLANNER-PATH* "pg-x11"))

      (t (load-path *PLANNER-PATH* "pg-system")))


(load-path *PLANNER-PATH* "graphics")              ;; domain
(load-path *PLANNER-PATH* "tree-graphics")         ;; tree 

;;
;;  user interface
;;

(load-path *PLANNER-PATH* "interface")
(load-path *PLANNER-PATH* "analyze")
(load-path *PLANNER-PATH* "toplevel")
(load-path *PLANNER-PATH* "commands")

(provide 'prodigy)

